/*
 * Decompiled with CFR 0.152.
 */
package sos.preview;

import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import javax.swing.UIManager;
import sos.preview.BasicPrintPreviewPaneUI;
import sos.preview.ZoomLayout;

public class ZoomLayoutFormat
extends Format {
    private NumberFormat format;

    public ZoomLayoutFormat() {
        this(NumberFormat.getPercentInstance());
    }

    public ZoomLayoutFormat(NumberFormat numberFormat) {
        this.format = numberFormat;
    }

    public ZoomLayoutFormat(Locale locale) {
        this(NumberFormat.getPercentInstance(locale));
    }

    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (!(object instanceof ZoomLayout)) {
            throw new IllegalArgumentException("Cannot format object.");
        }
        ZoomLayout zoomLayout = (ZoomLayout)object;
        double d = zoomLayout.getScale();
        stringBuffer.append(this.format.format(d));
        return stringBuffer;
    }

    public static Locale[] getAvailableLocales() {
        return NumberFormat.getAvailableLocales();
    }

    public static ZoomLayoutFormat getInstance() {
        return new ZoomLayoutFormat();
    }

    public static ZoomLayoutFormat getInstance(Locale locale) {
        return new ZoomLayoutFormat(NumberFormat.getPercentInstance(locale));
    }

    public Object parseObject(String string, ParsePosition parsePosition) {
        try {
            Number number = this.format.parse(string);
            double d = number.doubleValue();
            int n = UIManager.getInt(BasicPrintPreviewPaneUI.HORIZONTAL_ALIGNMENT);
            int n2 = UIManager.getInt(BasicPrintPreviewPaneUI.VERTICAL_ALIGNMENT);
            int n3 = UIManager.getInt(BasicPrintPreviewPaneUI.HORIZONTAL_SPACING);
            int n4 = UIManager.getInt(BasicPrintPreviewPaneUI.VERTICAL_SPACING);
            int n5 = UIManager.getInt(BasicPrintPreviewPaneUI.LEFT_MARGIN);
            int n6 = UIManager.getInt(BasicPrintPreviewPaneUI.RIGHT_MARGIN);
            int n7 = UIManager.getInt(BasicPrintPreviewPaneUI.TOP_MARGIN);
            int n8 = UIManager.getInt(BasicPrintPreviewPaneUI.BOTTOM_MARGIN);
            parsePosition.setIndex(string.length());
            return new ZoomLayout(d, n, n2, n3, n4, n5, n6, n7, n8);
        }
        catch (ParseException parseException) {
            return null;
        }
    }
}

