/*
 * Decompiled with CFR 0.152.
 */
package sos.preview;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;
import sos.preview.LayoutSupport;
import sos.preview.ScalingLayoutManager;
import sos.preview.ScrollableLayoutManager;
import sos.preview.Utility;

public class ZoomLayout
implements ScrollableLayoutManager,
ScalingLayoutManager,
Serializable {
    private static final double DEFAULT_SCALE = 1.0;
    private static final int DEFAULT_HORIZONTAL_SPACING = 10;
    private static final int DEFAULT_VERTICAL_SPACING = 10;
    private static final int DEFAULT_MINIMUM_LEFT_MARGIN = 10;
    private static final int DEFAULT_MINIMUM_RIGHT_MARGIN = 10;
    private static final int DEFAULT_MINIMUM_TOP_MARGIN = 10;
    private static final int DEFAULT_MINIMUM_BOTTOM_MARGIN = 10;
    private static final int DEFAULT_HORIZONTAL_ALIGNMENT = 0;
    private static final int DEFAULT_VERTICAL_ALIGNMENT = 0;
    private int horizontalSpacing;
    private int verticalSpacing;
    private int minLeftMargin;
    private int minRightMargin;
    private int minTopMargin;
    private int minBottomMargin;
    private double scale;
    private int horizontalAlignment;
    private int verticalAlignment;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$sos$preview$ZoomLayout;

    public ZoomLayout() {
        this(1.0, 0, 0, 10, 10, 10, 10, 10, 10);
    }

    public ZoomLayout(double d) throws IllegalArgumentException {
        this(d, 0, 0, 10, 10, 10, 10, 10, 10);
    }

    public ZoomLayout(double d, int n, int n2) throws IllegalArgumentException {
        this(d, n, n2, 10, 10, 10, 10, 10, 10);
    }

    public ZoomLayout(double d, int n, int n2, int n3, int n4, int n5, int n6) throws IllegalArgumentException {
        this(d, 0, 0, n, n2, n3, n4, n5, n6);
    }

    public ZoomLayout(double d, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) throws IllegalArgumentException {
        if (d <= 0.0) {
            throw new IllegalArgumentException("Zoom percentage must be greater than 0");
        }
        Utility.checkHorizontalAlignment(n);
        Utility.checkVerticalAlignment(n2);
        Utility.checkSpacing(n3, n4);
        Utility.checkMargins(n5, n6, n7, n8);
        this.scale = d;
        this.horizontalAlignment = n;
        this.verticalAlignment = n2;
        this.horizontalSpacing = n3;
        this.verticalSpacing = n4;
        this.minLeftMargin = n5;
        this.minRightMargin = n6;
        this.minTopMargin = n7;
        this.minBottomMargin = n8;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public Dimension getPreferredScrollableViewportSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public double preferredScale(Container container) {
        return this.scale;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ZoomLayout)) {
            return false;
        }
        ZoomLayout zoomLayout = (ZoomLayout)object;
        return this.getScale() == zoomLayout.getScale() && this.minLeftMargin == zoomLayout.minLeftMargin && this.minRightMargin == zoomLayout.minRightMargin && this.minTopMargin == zoomLayout.minTopMargin && this.minBottomMargin == zoomLayout.minBottomMargin && this.horizontalSpacing == zoomLayout.horizontalSpacing && this.verticalSpacing == zoomLayout.verticalSpacing && this.horizontalAlignment == zoomLayout.horizontalAlignment && this.verticalAlignment == zoomLayout.verticalAlignment;
    }

    public double getScale() {
        return this.scale;
    }

    public int getScrollableBlockIncrement(Container container, Rectangle rectangle, int n, int n2) {
        return n == 0 ? rectangle.width : rectangle.height;
    }

    public boolean getScrollableTracksViewportHeight(Container container) {
        return false;
    }

    public boolean getScrollableTracksViewportWidth(Container container) {
        Dimension dimension = this.preferredLayoutSize(container);
        return container.getSize().getWidth() > dimension.getWidth();
    }

    public int getScrollableUnitIncrement(Container container, Rectangle rectangle, int n, int n2) {
        return 20;
    }

    public int hashCode() {
        return (int)(this.getScale() * 31000.0 + (double)Utility.computeHashCode(this.horizontalAlignment, this.verticalAlignment, this.horizontalSpacing, this.verticalSpacing, this.minLeftMargin, this.minRightMargin, this.minTopMargin, this.minBottomMargin));
    }

    private Dimension idealPreferredLayoutSize(Container container) {
        LayoutSupport layoutSupport = LayoutSupport.getSupport(container);
        return layoutSupport.getLinearDimensions(this.scale, this.horizontalSpacing, this.verticalSpacing, this.minLeftMargin, this.minRightMargin, this.minTopMargin, this.minBottomMargin);
    }

    public void layoutContainer(Container container) {
        this.scaleComponents(container);
    }

    public double scaleComponents(Container container) {
        Dimension dimension = container.getSize();
        Insets insets = container.getInsets();
        int n = (int)dimension.getWidth() - insets.left - insets.right;
        int n2 = container.getComponentCount();
        if (n2 == 0) {
            return 1.0;
        }
        LayoutSupport layoutSupport = LayoutSupport.getSupport(container);
        double d = layoutSupport.getMaximumFixedWidth();
        double d2 = layoutSupport.getMaximumFixedHeight();
        double d3 = layoutSupport.getMaximumPreferredScaleableWidth();
        double d4 = layoutSupport.getMaximumPreferredScaleableHeight();
        double d5 = d + d3 * this.scale;
        double d6 = d2 + d4 * this.scale;
        int n3 = (int)Math.max((double)n, d5 + (double)this.minLeftMargin + (double)this.minRightMargin);
        int n4 = (int)((double)(n3 - (this.minLeftMargin + this.minRightMargin) + this.horizontalSpacing) / (d5 + (double)this.horizontalSpacing));
        n4 = Math.max(n4, 1);
        int n5 = Math.min(n4, n2);
        if (!$assertionsDisabled && n5 < 1) {
            throw new AssertionError();
        }
        int n6 = n2 / n5;
        if (n2 % n5 != 0) {
            ++n6;
        }
        int n7 = this.minLeftMargin;
        int n8 = this.minRightMargin;
        int n9 = this.minTopMargin;
        int n10 = this.minBottomMargin;
        if (n7 + n5 * (int)d5 + (n5 - 1) * this.horizontalSpacing + n8 < n) {
            int n11;
            int n12 = n - n5 * (int)d5 - (n5 - 1) * this.horizontalSpacing - this.minLeftMargin - this.minRightMargin;
            int n13 = n11 = n12 / 2;
            if (n12 % 2 != 0) {
                ++n13;
            }
            n7 = this.minLeftMargin + n11;
            n8 = this.minRightMargin + n13;
        }
        layoutSupport.layoutComponents(n6, n5, (int)d5, (int)d6, this.scale, this.horizontalSpacing, this.verticalSpacing, n7, n8, n9, n10, this.horizontalAlignment, this.verticalAlignment);
        return this.scale;
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.idealPreferredLayoutSize(container);
    }

    public Dimension preferredLayoutSize(Container container) {
        Container container2 = container.getParent();
        if (container2 == null) {
            return new Dimension(0, 0);
        }
        Dimension dimension = container2.getSize();
        double d = dimension.getWidth();
        double d2 = dimension.getHeight();
        if (d == 0.0 || d2 == 0.0) {
            return this.idealPreferredLayoutSize(container);
        }
        int n = container.getComponentCount();
        if (n == 0) {
            return dimension;
        }
        LayoutSupport layoutSupport = LayoutSupport.getSupport(container);
        double d3 = layoutSupport.getMaximumFixedWidth();
        double d4 = layoutSupport.getMaximumFixedHeight();
        double d5 = layoutSupport.getMaximumPreferredScaleableWidth();
        double d6 = layoutSupport.getMaximumPreferredScaleableHeight();
        double d7 = d3 + d5 * this.scale;
        double d8 = d4 + d6 * this.scale;
        int n2 = (int)Math.max(d, d7 + (double)this.minLeftMargin + (double)this.minRightMargin);
        int n3 = (int)((double)(n2 - (this.minLeftMargin + this.minRightMargin) + this.horizontalSpacing) / (d7 + (double)this.horizontalSpacing));
        n3 = Math.max(n3, 1);
        if (!$assertionsDisabled && n3 < 1) {
            throw new AssertionError();
        }
        int n4 = n / n3;
        if (n % n3 != 0) {
            ++n4;
        }
        double d9 = (double)(this.minTopMargin + this.minBottomMargin) + (double)n4 * d8 + (double)((n4 - 1) * this.verticalSpacing);
        int n5 = (int)Math.max(d2, d9);
        return new Dimension(n2, n5);
    }

    public void removeLayoutComponent(Component component) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$sos$preview$ZoomLayout == null ? (class$sos$preview$ZoomLayout = ZoomLayout.class$("sos.preview.ZoomLayout")) : class$sos$preview$ZoomLayout).desiredAssertionStatus();
    }
}

