/*
 * Decompiled with CFR 0.152.
 */
package sos.preview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import sos.preview.MatrixLayout;

class Utility {
    static /* synthetic */ Class class$sos$preview$Utility;

    private Utility() {
    }

    static void checkDeployment() {
        try {
            long l = System.currentTimeMillis();
            Preferences preferences = Preferences.systemNodeForPackage(class$sos$preview$Utility == null ? (class$sos$preview$Utility = Utility.class$("sos.preview.Utility")) : class$sos$preview$Utility);
            if (!preferences.nodeExists("Evaluation1.8.1")) {
                Preferences preferences2 = preferences.node("Evaluation1.8.1");
                preferences2.putLong("FirstUse", l);
                preferences2.putInt("Use", 1);
                System.out.println("Print Preview Library Evaluation Copy (" + new Date(l) + "): First use.");
            } else {
                Preferences preferences3 = preferences.node("Evaluation1.8.1");
                long l2 = preferences3.getLong("FirstUse", l);
                int n = preferences3.getInt("Use", 0);
                if (l2 == l || n == 0) {
                    throw new RuntimeException("You must have access to the system preferences in order to run the evaluation version of the Print Preview Library.");
                }
                System.out.println("Print Preview Library Evaluation Copy (" + new Date(l2) + "): " + (n + 1) + " uses.");
                long l3 = l2 + 2592000000L;
                if ((l2 > l || l >= l3) && n > 20) {
                    throw new RuntimeException("The evaluation period of the Print Preview Library has expired. Contact Side of Software at info@sideofsoftware.com to purchase a developer's license.");
                }
                preferences3.putInt("Use", n + 1);
            }
        }
        catch (BackingStoreException backingStoreException) {
            throw new RuntimeException("You must have access to the system preferences in order to run the evaluation version of the Print Preview Library.");
        }
        catch (SecurityException securityException) {
            throw new RuntimeException("You must have access to the system preferences in order to run the evaluation version of the Print Preview Library.");
        }
    }

    static void checkDeployment(String[] stringArray) {
        RuntimeException runtimeException = new RuntimeException("You are using an illegal version of the Print Preview Library. Contact Side of Software at info@sideofsoftware.com to purchase a developer's license.");
        StackTraceElement[] stackTraceElementArray = runtimeException.getStackTrace();
        int n = 0;
        while (n < stackTraceElementArray.length) {
            StackTraceElement stackTraceElement = stackTraceElementArray[n];
            String string = stackTraceElement.getClassName();
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (string.startsWith(stringArray[n2])) {
                    return;
                }
                ++n2;
            }
            ++n;
        }
        throw runtimeException;
    }

    static void checkDeployment(int n, int n2, int n3) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(n, n2, n3);
        Date date = calendar.getTime();
        Date date2 = new Date();
        if (date2.compareTo(date) > 0) {
            throw new RuntimeException("The evaluation period of the Print Preview Library has expired. Contact Side of Software at info@sideofsoftware.com to purchase a developer's license.");
        }
    }

    static void checkHorizontalAlignment(int n) {
        if (n != 2 && n != 0 && n != 4 && n != 10 && n != 11) {
            throw new IllegalArgumentException("Invalid horizontal alignment");
        }
    }

    static void checkMargins(int n, int n2, int n3, int n4) {
        if (n < 0 || n2 < 0 || n3 < 0 || n4 < 0) {
            throw new IllegalArgumentException("Margins cannot be negative");
        }
    }

    static void checkNull(Object object, String string) {
        if (object == null) {
            throw new NullPointerException(string + " cannot be null");
        }
    }

    static void checkSpacing(int n, int n2) {
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Spacing cannot be negative");
        }
    }

    static void checkVerticalAlignment(int n) {
        if (n != 1 && n != 3 && n != 0) {
            throw new IllegalArgumentException("Invalid vertical alignment");
        }
    }

    static int computeHashCode(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return n * 31 + n2 * 31 + n3 * 31 + n4 * 31 + n5 * 31 + n6 * 31 + n7 * 31 + n8 * 31;
    }

    static void initDefault(Object object, Object object2) {
        Object object3 = UIManager.get(object);
        if (object3 == null) {
            UIManager.put(object, object2);
        }
    }

    static void installDefaultBackground(Component component, Object object) {
        Color color = component.getBackground();
        if (color == null || color instanceof UIResource) {
            color = UIManager.getColor(object);
            component.setBackground(color);
        }
    }

    static void installDefaultForeground(Component component, Object object) {
        Color color = component.getForeground();
        if (color == null || color instanceof UIResource) {
            color = UIManager.getColor(object);
            component.setForeground(color);
        }
    }

    static boolean isOnePageLayout(LayoutManager layoutManager) {
        if (!(layoutManager instanceof MatrixLayout)) {
            return false;
        }
        MatrixLayout matrixLayout = (MatrixLayout)layoutManager;
        return matrixLayout.getRowCount() == 1 && matrixLayout.getColumnCount() == 1;
    }

    static Cursor loadCursor(Object object, String string, Point point, String string2) {
        Image image = Utility.loadImage(object, string);
        if (image == null) {
            return null;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Cursor cursor = toolkit.createCustomCursor(image, point, string2);
        return cursor;
    }

    static ImageIcon loadIcon(Object object, String string) {
        Image image = Utility.loadImage(object, string);
        if (image == null) {
            return null;
        }
        ImageIcon imageIcon = new ImageIcon(image);
        return imageIcon;
    }

    static Image loadImage(Object object, String string) {
        ClassLoader classLoader = object.getClass().getClassLoader();
        URL uRL = classLoader.getResource(string);
        if (uRL == null) {
            return null;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.createImage(uRL);
        return image;
    }

    static void uninstallDefaultBackground(Component component) {
        Color color = component.getBackground();
        if (color instanceof UIResource) {
            component.setBackground(null);
        }
    }

    static void uninstallDefaultForeground(Component component) {
        Color color = component.getForeground();
        if (color instanceof UIResource) {
            component.setForeground(null);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

