/*
 * Decompiled with CFR 0.152.
 */
package sos.preview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.NumberFormatter;
import sos.preview.FitAllLayoutFormat;
import sos.preview.FitLayoutFormat;
import sos.preview.JPrintPreviewPane;
import sos.preview.MatrixLayoutFormat;
import sos.preview.PrintPreviewPaneUI;
import sos.preview.SeparatorComboBoxModel;
import sos.preview.SeparatorListCellRenderer;
import sos.preview.Utility;
import sos.preview.ZoomLayoutFormat;

public class PrintPreviewSupport {
    public static final int ZOOM = 0;
    public static final int ZOOM_IN_OUT = 1;
    public static final int ZOOM_IN_OUT_TOGGLE = 2;
    public static final int ZOOM_TOGGLE = 3;
    private static NumberFormat zoomFormat;
    private JPrintPreviewPane printPreviewPane;
    private boolean large;
    private int currentPageIndex = 0;
    private NumberFormatter formatter;
    private PageableFactory pageableFactory;
    private JButton printButton;
    private Action printAction;
    private JButton printAllButton;
    private Action printAllAction;
    private Action pageSetupAction;
    private JButton pageSetupButton;
    private Action closeAction;
    private JButton closeButton;
    private Action zoomToggleAction;
    private JToggleButton zoomToggleButton;
    private Action zoomInAction;
    private JButton zoomInButton;
    private Action zoomInToggleAction;
    private JToggleButton zoomInToggleButton;
    private Action zoomOutAction;
    private JButton zoomOutButton;
    private Action zoomOutToggleAction;
    private JToggleButton zoomOutToggleButton;
    private ButtonGroup zoomInOutToggleGroup;
    private JFormattedTextField pageField;
    private Action nextPageAction;
    private JButton nextPageButton;
    private Action previousPageAction;
    private JButton previousPageButton;
    private Action firstPageAction;
    private JButton firstPageButton;
    private Action lastPageAction;
    private JButton lastPageButton;
    private JComboBox zoomComboBox;
    static /* synthetic */ Class class$sos$preview$JPrintPreviewPane;
    static /* synthetic */ Class class$sos$preview$PrintPreviewSupport;
    static /* synthetic */ Class class$sos$preview$ZoomLayout;
    static /* synthetic */ Class class$sos$preview$MatrixLayout;
    static /* synthetic */ Class class$sos$preview$FitLayout;
    static /* synthetic */ Class class$sos$preview$FitAllLayout;

    public PrintPreviewSupport(JPrintPreviewPane jPrintPreviewPane, boolean bl) {
        this.printPreviewPane = jPrintPreviewPane;
        this.large = bl;
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                block24: {
                    String string;
                    block25: {
                        block23: {
                            string = propertyChangeEvent.getPropertyName();
                            if (!"scale".equals(string)) break block23;
                            if (PrintPreviewSupport.this.zoomComboBox == null || !PrintPreviewSupport.this.zoomComboBox.isEditable()) {
                                return;
                            }
                            LayoutManager layoutManager = PrintPreviewSupport.this.printPreviewPane.getLayout();
                            PrintPreviewSupport.this.zoomComboBox.setSelectedItem(layoutManager);
                            break block24;
                        }
                        if (!"mode".equals(string)) break block25;
                        Integer n = (Integer)propertyChangeEvent.getOldValue();
                        int n2 = n;
                        Integer n3 = (Integer)propertyChangeEvent.getNewValue();
                        int n4 = n3;
                        switch (n2) {
                            case 1: {
                                if (PrintPreviewSupport.this.zoomToggleButton == null) break;
                                PrintPreviewSupport.this.zoomToggleButton.setSelected(false);
                                break;
                            }
                            case 2: {
                                if (PrintPreviewSupport.this.zoomInToggleButton == null) break;
                                PrintPreviewSupport.this.zoomInToggleButton.setSelected(false);
                                break;
                            }
                            case 3: {
                                if (PrintPreviewSupport.this.zoomOutToggleButton == null) break;
                                PrintPreviewSupport.this.zoomOutToggleButton.setSelected(false);
                                break;
                            }
                            case 0: {
                                break;
                            }
                            default: {
                                throw new AssertionError((Object)("Unrecognized print preview mode: " + n2));
                            }
                        }
                        switch (n4) {
                            case 1: {
                                if (PrintPreviewSupport.this.zoomToggleButton != null) {
                                    PrintPreviewSupport.this.zoomToggleButton.setSelected(true);
                                }
                                break block24;
                            }
                            case 2: {
                                if (PrintPreviewSupport.this.zoomInToggleButton != null) {
                                    PrintPreviewSupport.this.zoomInToggleButton.setSelected(true);
                                }
                                break block24;
                            }
                            case 3: {
                                if (PrintPreviewSupport.this.zoomOutToggleButton != null) {
                                    PrintPreviewSupport.this.zoomOutToggleButton.setSelected(true);
                                }
                                break block24;
                            }
                            case 0: {
                                break block24;
                            }
                            default: {
                                throw new AssertionError((Object)("Unrecognized print preview mode: " + n4));
                            }
                        }
                    }
                    if ("pageable".equals(string)) {
                        Pageable pageable = (Pageable)propertyChangeEvent.getNewValue();
                        int n = pageable.getNumberOfPages();
                        if (PrintPreviewSupport.this.currentPageIndex >= n) {
                            PrintPreviewSupport.this.setCurrentPageIndex(0);
                        } else {
                            PrintPreviewSupport.this.setCurrentPageIndex(PrintPreviewSupport.this.currentPageIndex);
                        }
                        if (PrintPreviewSupport.this.formatter != null) {
                            PrintPreviewSupport.this.formatter.setMaximum(new Integer(n));
                        }
                    } else if ("layout".equals(string)) {
                        if (PrintPreviewSupport.this.zoomComboBox == null) {
                            return;
                        }
                        Object object = propertyChangeEvent.getNewValue();
                        PrintPreviewSupport.this.zoomComboBox.setSelectedItem(object);
                    }
                }
            }
        };
        jPrintPreviewPane.addPropertyChangeListener(propertyChangeListener);
    }

    private void addPrintButton(JToolBar jToolBar, boolean bl) {
        JButton jButton = bl ? this.getPrintButton() : this.getPrintAllButton();
        jToolBar.add(jButton);
    }

    private Action createAction(String string) {
        try {
            String string2 = "sos.preview.PrintPreviewSupport$" + string + "Action";
            Class<?> clazz = Class.forName(string2);
            Constructor<?> constructor = clazz.getDeclaredConstructor(class$sos$preview$PrintPreviewSupport == null ? (class$sos$preview$PrintPreviewSupport = PrintPreviewSupport.class$("sos.preview.PrintPreviewSupport")) : class$sos$preview$PrintPreviewSupport);
            Action action = (Action)constructor.newInstance(this);
            String string3 = "get" + string + "Text";
            Method method = (class$sos$preview$PrintPreviewSupport == null ? (class$sos$preview$PrintPreviewSupport = PrintPreviewSupport.class$("sos.preview.PrintPreviewSupport")) : class$sos$preview$PrintPreviewSupport).getDeclaredMethod(string3, null);
            String string4 = (String)method.invoke((Object)this, (Object[])null);
            action.putValue("Name", string4);
            String string5 = "get" + string + "Icon";
            Method method2 = (class$sos$preview$PrintPreviewSupport == null ? (class$sos$preview$PrintPreviewSupport = PrintPreviewSupport.class$("sos.preview.PrintPreviewSupport")) : class$sos$preview$PrintPreviewSupport).getDeclaredMethod(string5, null);
            Icon icon = (Icon)method2.invoke((Object)this, (Object[])null);
            action.putValue("SmallIcon", icon);
            String string6 = "get" + string + "ToolTip";
            Method method3 = (class$sos$preview$PrintPreviewSupport == null ? (class$sos$preview$PrintPreviewSupport = PrintPreviewSupport.class$("sos.preview.PrintPreviewSupport")) : class$sos$preview$PrintPreviewSupport).getDeclaredMethod(string6, null);
            String string7 = (String)method3.invoke((Object)this, (Object[])null);
            action.putValue("ShortDescription", string7);
            String string8 = "get" + string + "Mnemonic";
            Method method4 = (class$sos$preview$PrintPreviewSupport == null ? (class$sos$preview$PrintPreviewSupport = PrintPreviewSupport.class$("sos.preview.PrintPreviewSupport")) : class$sos$preview$PrintPreviewSupport).getDeclaredMethod(string8, null);
            Integer n = (Integer)method4.invoke((Object)this, (Object[])null);
            action.putValue("MnemonicKey", n);
            return action;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Object)classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new AssertionError((Object)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw (RuntimeException)invocationTargetException.getCause();
        }
    }

    protected JButton createButton(Action action) {
        return new JButton(action);
    }

    protected Action createFirstPageAction() {
        Action action = this.createAction("FirstPage");
        action.setEnabled(false);
        return action;
    }

    protected Action createLastPageAction() {
        Action action = this.createAction("LastPage");
        Pageable pageable = this.printPreviewPane.getPageable();
        int n = pageable.getNumberOfPages();
        if (n <= 1) {
            action.setEnabled(false);
        }
        return action;
    }

    protected Action createNextPageAction() {
        Action action = this.createAction("NextPage");
        Pageable pageable = this.printPreviewPane.getPageable();
        int n = pageable.getNumberOfPages();
        if (n <= 1) {
            action.setEnabled(false);
        }
        return action;
    }

    protected JFormattedTextField createPageField() {
        Pageable pageable = this.printPreviewPane.getPageable();
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        this.formatter = new NumberFormatter(numberFormat);
        Integer n = new Integer(1);
        this.formatter.setMinimum(n);
        this.formatter.setMaximum(new Integer(pageable.getNumberOfPages()));
        final JFormattedTextField jFormattedTextField = new JFormattedTextField(this.formatter);
        jFormattedTextField.setHorizontalAlignment(0);
        jFormattedTextField.setValue(n);
        jFormattedTextField.setColumns(4);
        jFormattedTextField.setMaximumSize(jFormattedTextField.getPreferredSize());
        jFormattedTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        2.access$800(this.this$1).selectAll();
                    }
                });
            }

            static /* synthetic */ JFormattedTextField access$800(2 var0) {
                return var0.jFormattedTextField;
            }
        });
        jFormattedTextField.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "check");
        jFormattedTextField.getActionMap().put("check", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!jFormattedTextField.isEditValid()) {
                    LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
                    lookAndFeel.provideErrorFeedback(jFormattedTextField);
                    jFormattedTextField.selectAll();
                } else {
                    try {
                        jFormattedTextField.commitEdit();
                    }
                    catch (ParseException parseException) {}
                }
            }
        });
        jFormattedTextField.addPropertyChangeListener("value", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Number number = (Number)propertyChangeEvent.getNewValue();
                int n = number.intValue();
                Pageable pageable = PrintPreviewSupport.this.printPreviewPane.getPageable();
                int n2 = pageable.getNumberOfPages();
                if (n <= 0 || n > n2) {
                    return;
                }
                PrintPreviewSupport.this.setCurrentPageIndex(n - 1);
                PrintPreviewSupport.this.printPreviewPane.centerPage(PrintPreviewSupport.this.currentPageIndex);
            }
        });
        String string = this.getPageFieldToolTip();
        jFormattedTextField.setToolTipText(string);
        return jFormattedTextField;
    }

    protected Action createPageSetupAction(PageableFactory pageableFactory) {
        this.pageableFactory = pageableFactory;
        return this.createAction("PageSetup");
    }

    public static JPanel createNavigationPanel(PageableFactory pageableFactory, boolean bl, Action action, boolean bl2) throws NullPointerException {
        PageFormat pageFormat = new PageFormat();
        Pageable pageable = pageableFactory.createPageable(pageFormat);
        return PrintPreviewSupport.createNavigationPanel(bl, pageable, pageableFactory, action, bl2);
    }

    public static JPanel createNavigationPanel(Pageable pageable, boolean bl, Action action, boolean bl2) {
        return PrintPreviewSupport.createNavigationPanel(bl, pageable, null, action, bl2);
    }

    private static JPanel createNavigationPanel(boolean bl, Pageable pageable, PageableFactory pageableFactory, Action action, boolean bl2) {
        JComponent jComponent;
        JButton jButton;
        JPanel jPanel = new JPanel(new BorderLayout());
        JPrintPreviewPane jPrintPreviewPane = new JPrintPreviewPane(pageable);
        PrintPreviewPaneUI printPreviewPaneUI = jPrintPreviewPane.getUI();
        LayoutManager layoutManager = printPreviewPaneUI.createMatrixLayout(jPrintPreviewPane, 1, 1);
        jPrintPreviewPane.setLayout(layoutManager);
        jPrintPreviewPane.setPageNumbersAreShown(false);
        jPrintPreviewPane.setPageSelectionAllowed(false);
        PrintPreviewSupport printPreviewSupport = new PrintPreviewSupport(jPrintPreviewPane, bl2);
        JToolBar jToolBar = new JToolBar();
        printPreviewSupport.addPrintButton(jToolBar, bl);
        jToolBar.addSeparator();
        if (pageableFactory != null) {
            jButton = printPreviewSupport.getPageSetupButton(pageableFactory);
            jToolBar.add(jButton);
            jToolBar.addSeparator();
        }
        jButton = printPreviewSupport.getFirstPageButton();
        jButton.setText("");
        jToolBar.add(jButton);
        JButton jButton2 = printPreviewSupport.getPreviousPageButton();
        jButton2.setText("");
        jToolBar.add(jButton2);
        jToolBar.addSeparator();
        JFormattedTextField jFormattedTextField = printPreviewSupport.getPageField();
        jToolBar.add(jFormattedTextField);
        jToolBar.addSeparator();
        JButton jButton3 = printPreviewSupport.getNextPageButton();
        jButton3.setText("");
        jToolBar.add(jButton3);
        JButton jButton4 = printPreviewSupport.getLastPageButton();
        jButton4.setText("");
        jToolBar.add(jButton4);
        if (action != null) {
            jToolBar.addSeparator();
            jComponent = printPreviewSupport.getCloseButton(action);
            jToolBar.add(jComponent);
        }
        jPanel.add((Component)jToolBar, "First");
        jComponent = new JScrollPane(jPrintPreviewPane, 21, 31);
        jPanel.add((Component)jComponent, "Center");
        return jPanel;
    }

    protected Action createPreviousPageAction() {
        Action action = this.createAction("PreviousPage");
        action.setEnabled(false);
        return action;
    }

    protected Action createPrintAction() {
        return this.createAction("Print");
    }

    protected Action createPrintAllAction() {
        return this.createAction("PrintAll");
    }

    protected JToggleButton createToggleButton(Action action) {
        return new JToggleButton(action);
    }

    public static JPanel createZoomPanel(PageableFactory pageableFactory, boolean bl, int n, Action action, boolean bl2) throws IllegalArgumentException, NullPointerException {
        PageFormat pageFormat = new PageFormat();
        Pageable pageable = pageableFactory.createPageable(pageFormat);
        return PrintPreviewSupport.createZoomPanel(bl, pageable, pageableFactory, action, bl2, n);
    }

    public static JPanel createZoomPanel(Pageable pageable, boolean bl, int n, Action action, boolean bl2) throws IllegalArgumentException, NullPointerException {
        return PrintPreviewSupport.createZoomPanel(bl, pageable, null, action, bl2, n);
    }

    private static JPanel createZoomPanel(boolean bl, Pageable pageable, PageableFactory pageableFactory, Action action, boolean bl2, int n) {
        JComponent jComponent;
        JComponent jComponent2;
        JPanel jPanel = new JPanel(new BorderLayout());
        JPrintPreviewPane jPrintPreviewPane = new JPrintPreviewPane(pageable);
        PrintPreviewPaneUI printPreviewPaneUI = jPrintPreviewPane.getUI();
        LayoutManager layoutManager = printPreviewPaneUI.createMatrixLayout(jPrintPreviewPane, 1, 1);
        jPrintPreviewPane.setLayout(layoutManager);
        PrintPreviewSupport printPreviewSupport = new PrintPreviewSupport(jPrintPreviewPane, bl2);
        JToolBar jToolBar = new JToolBar();
        printPreviewSupport.addPrintButton(jToolBar, bl);
        jToolBar.addSeparator();
        if (pageableFactory != null) {
            jComponent2 = printPreviewSupport.getPageSetupButton(pageableFactory);
            jToolBar.add(jComponent2);
            jToolBar.addSeparator();
        }
        switch (n) {
            case 0: {
                jPrintPreviewPane.setMode(1);
                break;
            }
            case 3: {
                jComponent2 = printPreviewSupport.getZoomToggleButton();
                jComponent2.setText("");
                jToolBar.add(jComponent2);
                jToolBar.addSeparator();
                break;
            }
            case 2: {
                jComponent2 = printPreviewSupport.getZoomInToggleButton();
                jComponent2.setText("");
                jComponent2.doClick();
                jToolBar.add(jComponent2);
                jComponent = printPreviewSupport.getZoomOutToggleButton();
                jComponent.setText("");
                jToolBar.add(jComponent);
                jToolBar.addSeparator();
                break;
            }
            case 1: {
                jComponent2 = printPreviewSupport.getZoomInButton();
                jComponent2.setText("");
                jToolBar.add(jComponent2);
                jComponent = printPreviewSupport.getZoomOutButton();
                jComponent.setText("");
                jToolBar.add(jComponent);
                jToolBar.addSeparator();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid zoomFlavor " + n);
            }
        }
        jComponent2 = printPreviewSupport.getZoomComboBox(true, true);
        jToolBar.add(jComponent2);
        if (action != null) {
            jToolBar.addSeparator();
            jComponent = printPreviewSupport.getCloseButton(action);
            jToolBar.add(jComponent);
        }
        jPanel.add((Component)jToolBar, "First");
        jComponent = new JScrollPane(jPrintPreviewPane);
        jPanel.add((Component)jComponent, "Center");
        return jPanel;
    }

    protected JComboBox createZoomComboBox(boolean bl, boolean bl2) {
        final JComboBox<Object> jComboBox = new JComboBox<Object>(new SeparatorComboBoxModel());
        jComboBox.setEditable(bl);
        String string = this.getZoomComboBoxToolTipText();
        jComboBox.setToolTipText(string);
        LinkedHashMap<Class, Format> linkedHashMap = new LinkedHashMap<Class, Format>();
        linkedHashMap.put(class$sos$preview$ZoomLayout == null ? (class$sos$preview$ZoomLayout = PrintPreviewSupport.class$("sos.preview.ZoomLayout")) : class$sos$preview$ZoomLayout, new ZoomLayoutFormat(zoomFormat));
        linkedHashMap.put(class$sos$preview$MatrixLayout == null ? (class$sos$preview$MatrixLayout = PrintPreviewSupport.class$("sos.preview.MatrixLayout")) : class$sos$preview$MatrixLayout, MatrixLayoutFormat.getInstance());
        linkedHashMap.put(class$sos$preview$FitLayout == null ? (class$sos$preview$FitLayout = PrintPreviewSupport.class$("sos.preview.FitLayout")) : class$sos$preview$FitLayout, FitLayoutFormat.getInstance());
        linkedHashMap.put(class$sos$preview$FitAllLayout == null ? (class$sos$preview$FitAllLayout = PrintPreviewSupport.class$("sos.preview.FitAllLayout")) : class$sos$preview$FitAllLayout, FitAllLayoutFormat.getInstance());
        LayoutCellRenderer layoutCellRenderer = new LayoutCellRenderer(linkedHashMap);
        jComboBox.setRenderer(new SeparatorListCellRenderer(layoutCellRenderer));
        ZoomFormatter zoomFormatter = new ZoomFormatter(linkedHashMap);
        jComboBox.setEditor(new ZoomComboBoxEditor(zoomFormatter));
        HashMap hashMap = new HashMap();
        jComboBox.getEditor().getEditorComponent().addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 6 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        ComboBoxEditor comboBoxEditor = 6.access$1100(this.this$1).getEditor();
                        comboBoxEditor.selectAll();
                    }
                });
            }

            static /* synthetic */ JComboBox access$1100(6 var0) {
                return var0.jComboBox;
            }
        });
        List list = this.getZoomLayouts();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            jComboBox.addItem(iterator.next());
        }
        if (bl2) {
            jComboBox.addItem(SeparatorListCellRenderer.SEPARATOR);
            List list2 = this.getSpecialLayouts();
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                jComboBox.addItem(iterator2.next());
            }
        }
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    Object object = itemEvent.getItem();
                    LayoutManager layoutManager = (LayoutManager)object;
                    PrintPreviewSupport.this.printPreviewPane.setLayout(layoutManager);
                }
            }
        });
        jComboBox.setMaximumSize(jComboBox.getMinimumSize());
        return jComboBox;
    }

    protected Action createZoomInAction() {
        return this.createAction("ZoomIn");
    }

    protected Action createZoomInToggleAction() {
        return this.createAction("ZoomInToggle");
    }

    protected Action createZoomOutAction() {
        return this.createAction("ZoomOut");
    }

    protected Action createZoomOutToggleAction() {
        return this.createAction("ZoomOutToggle");
    }

    protected Action createZoomToggleAction() {
        return this.createAction("ZoomToggle");
    }

    public JButton getCloseButton(Action action) {
        Object object;
        Object object2;
        if (this.closeButton != null) {
            return this.closeButton;
        }
        Object object3 = action.getValue("Name");
        if (object3 == null) {
            object3 = this.getCloseText();
            action.putValue("Name", object3);
        }
        if ((object2 = action.getValue("MnemonicKey")) == null) {
            int n = this.getCloseMnemonic();
            object2 = new Integer(n);
            action.putValue("MnemonicKey", object2);
        }
        if ((object = action.getValue("ShortDescription")) == null) {
            object = this.getCloseToolTip();
            action.putValue("ShortDescription", object);
        }
        this.closeAction = action;
        this.closeButton = this.createButton(action);
        return this.closeButton;
    }

    public int getCloseMnemonic() {
        return this.lookupMnemonic("JPrintPreviewPane.closeButtonMnemonic");
    }

    public String getCloseText() {
        return this.lookupResource("JPrintPreviewPane.closeButtonText");
    }

    public String getCloseToolTip() {
        return this.lookupResource("JPrintPreviewPane.closeButtonToolTipText");
    }

    public Action getFirstPageAction() {
        if (this.firstPageAction != null) {
            return this.firstPageAction;
        }
        this.firstPageAction = this.createFirstPageAction();
        return this.firstPageAction;
    }

    public JButton getFirstPageButton() {
        if (this.firstPageButton != null) {
            return this.firstPageButton;
        }
        Action action = this.getFirstPageAction();
        this.firstPageButton = this.createButton(action);
        return this.firstPageButton;
    }

    public Icon getFirstPageIcon() {
        return this.loadOrientationDependentIcon("toolbarButtonGraphics/media/Rewind16.gif", "toolbarButtonGraphics/media/Rewind24.gif", "toolbarButtonGraphics/media/FastForward16.gif", "toolbarButtonGraphics/media/FastForward24.gif");
    }

    public int getFirstPageMnemonic() {
        return this.lookupMnemonic("JPrintPreviewPane.firstPageButtonMnemonic");
    }

    public String getFirstPageText() {
        return this.lookupResource("JPrintPreviewPane.firstPageButtonText");
    }

    public String getFirstPageToolTip() {
        return this.lookupResource("JPrintPreviewPane.firstPageButtonToolTipText");
    }

    public boolean getLargeIconsAreUsed() {
        return this.large;
    }

    public Action getLastPageAction() {
        if (this.lastPageAction != null) {
            return this.lastPageAction;
        }
        this.lastPageAction = this.createLastPageAction();
        return this.lastPageAction;
    }

    public JButton getLastPageButton() {
        if (this.lastPageButton != null) {
            return this.lastPageButton;
        }
        Action action = this.getLastPageAction();
        this.lastPageButton = this.createButton(action);
        return this.lastPageButton;
    }

    public Icon getLastPageIcon() {
        return this.loadOrientationDependentIcon("toolbarButtonGraphics/media/FastForward16.gif", "toolbarButtonGraphics/media/FastForward24.gif", "toolbarButtonGraphics/media/Rewind16.gif", "toolbarButtonGraphics/media/Rewind24.gif");
    }

    public int getLastPageMnemonic() {
        return this.lookupMnemonic("JPrintPreviewPane.lastPageButtonMnemonic");
    }

    public String getLastPageText() {
        return this.lookupResource("JPrintPreviewPane.lastPageButtonText");
    }

    public String getLastPageToolTip() {
        return this.lookupResource("JPrintPreviewPane.lastPageButtonToolTipText");
    }

    public Action getNextPageAction() {
        if (this.nextPageAction != null) {
            return this.nextPageAction;
        }
        this.nextPageAction = this.createNextPageAction();
        return this.nextPageAction;
    }

    public JButton getNextPageButton() {
        if (this.nextPageButton != null) {
            return this.nextPageButton;
        }
        Action action = this.getNextPageAction();
        this.nextPageButton = this.createButton(action);
        return this.nextPageButton;
    }

    public Icon getNextPageIcon() {
        return this.loadOrientationDependentIcon("toolbarButtonGraphics/media/StepForward16.gif", "toolbarButtonGraphics/media/StepForward24.gif", "toolbarButtonGraphics/media/StepBack16.gif", "toolbarButtonGraphics/media/StepBack24.gif");
    }

    public int getNextPageMnemonic() {
        return this.lookupMnemonic("JPrintPreviewPane.nextPageButtonMnemonic");
    }

    public String getNextPageText() {
        return this.lookupResource("JPrintPreviewPane.nextPageButtonText");
    }

    public String getNextPageToolTip() {
        return this.lookupResource("JPrintPreviewPane.nextPageButtonToolTipText");
    }

    private PageableFactory getPageableFactory() {
        return this.pageableFactory;
    }

    public JFormattedTextField getPageField() {
        if (this.pageField != null) {
            return this.pageField;
        }
        this.pageField = this.createPageField();
        return this.pageField;
    }

    public String getPageFieldToolTip() {
        return this.lookupResource("JPrintPreviewPane.pageFieldToolTipText");
    }

    public Action getPageSetupAction(PageableFactory pageableFactory) {
        if (this.pageSetupAction != null) {
            return this.pageSetupAction;
        }
        this.pageSetupAction = this.createPageSetupAction(pageableFactory);
        return this.pageSetupAction;
    }

    public JButton getPageSetupButton(PageableFactory pageableFactory) {
        if (this.pageSetupButton != null) {
            return this.pageSetupButton;
        }
        Action action = this.getPageSetupAction(pageableFactory);
        this.pageSetupButton = this.createButton(action);
        return this.pageSetupButton;
    }

    public Icon getPageSetupIcon() {
        return this.loadIcon("toolbarButtonGraphics/general/PageSetup16.gif", "toolbarButtonGraphics/general/PageSetup24.gif");
    }

    public int getPageSetupMnemonic() {
        return this.lookupMnemonic("JPrintPreviewPane.pageSetupButtonMnemonic");
    }

    public String getPageSetupText() {
        return this.lookupResource("JPrintPreviewPane.pageSetupButtonText");
    }

    public String getPageSetupToolTip() {
        return this.lookupResource("JPrintPreviewPane.pageSetupButtonToolTipText");
    }

    public Action getPreviousPageAction() {
        if (this.previousPageAction != null) {
            return this.previousPageAction;
        }
        this.previousPageAction = this.createPreviousPageAction();
        return this.previousPageAction;
    }

    public JButton getPreviousPageButton() {
        if (this.previousPageButton != null) {
            return this.previousPageButton;
        }
        Action action = this.getPreviousPageAction();
        this.previousPageButton = this.createButton(action);
        return this.previousPageButton;
    }

    public Icon getPreviousPageIcon() {
        return this.loadOrientationDependentIcon("toolbarButtonGraphics/media/StepBack16.gif", "toolbarButtonGraphics/media/StepBack24.gif", "toolbarButtonGraphics/media/StepForward16.gif", "toolbarButtonGraphics/media/StepForward24.gif");
    }

    public int getPreviousPageMnemonic() {
        return this.lookupMnemonic("JPrintPreviewPane.previousPageButtonMnemonic");
    }

    public String getPreviousPageText() {
        return this.lookupResource("JPrintPreviewPane.previousPageButtonText");
    }

    public String getPreviousPageToolTip() {
        return this.lookupResource("JPrintPreviewPane.previousPageButtonToolTipText");
    }

    public JPrintPreviewPane getPrintPreviewPane() {
        return this.printPreviewPane;
    }

    public Action getPrintAction() {
        if (this.printAction != null) {
            return this.printAction;
        }
        this.printAction = this.createPrintAction();
        return this.printAction;
    }

    public JButton getPrintButton() {
        if (this.printButton != null) {
            return this.printButton;
        }
        Action action = this.getPrintAction();
        this.printButton = this.createButton(action);
        return this.printButton;
    }

    public Action getPrintAllAction() {
        if (this.printAllAction != null) {
            return this.printAllAction;
        }
        this.printAllAction = this.createPrintAllAction();
        return this.printAllAction;
    }

    public JButton getPrintAllButton() {
        if (this.printAllButton != null) {
            return this.printAllButton;
        }
        Action action = this.getPrintAllAction();
        this.printAllButton = this.createButton(action);
        return this.printAllButton;
    }

    public Icon getPrintAllIcon() {
        return this.loadIcon("toolbarButtonGraphics/general/Print16.gif", "toolbarButtonGraphics/general/Print24.gif");
    }

    public int getPrintAllMnemonic() {
        return this.lookupMnemonic("JPrintPreviewPane.printAllButtonMnemonic");
    }

    public String getPrintAllText() {
        return this.lookupResource("JPrintPreviewPane.printAllButtonText");
    }

    public String getPrintAllToolTip() {
        return this.lookupResource("JPrintPreviewPane.printAllButtonToolTipText");
    }

    public Icon getPrintIcon() {
        return this.loadIcon("toolbarButtonGraphics/general/Print16.gif", "toolbarButtonGraphics/general/Print24.gif");
    }

    public int getPrintMnemonic() {
        return this.lookupMnemonic("JPrintPreviewPane.printButtonMnemonic");
    }

    public String getPrintText() {
        return this.lookupResource("JPrintPreviewPane.printButtonText");
    }

    public String getPrintToolTip() {
        return this.lookupResource("JPrintPreviewPane.printButtonToolTipText");
    }

    public List getSpecialLayouts() {
        ArrayList<LayoutManager> arrayList = new ArrayList<LayoutManager>(4);
        JPrintPreviewPane jPrintPreviewPane = this.getPrintPreviewPane();
        PrintPreviewPaneUI printPreviewPaneUI = jPrintPreviewPane.getUI();
        LayoutManager layoutManager = printPreviewPaneUI.createFitAllLayout(jPrintPreviewPane);
        arrayList.add(layoutManager);
        LayoutManager layoutManager2 = printPreviewPaneUI.createFitLayout(jPrintPreviewPane);
        arrayList.add(layoutManager2);
        LayoutManager layoutManager3 = printPreviewPaneUI.createMatrixLayout(jPrintPreviewPane, 1, 1);
        arrayList.add(layoutManager3);
        LayoutManager layoutManager4 = printPreviewPaneUI.createMatrixLayout(jPrintPreviewPane, 1, 2);
        arrayList.add(layoutManager4);
        return arrayList;
    }

    public JComboBox getZoomComboBox(boolean bl, boolean bl2) {
        if (this.zoomComboBox != null) {
            return this.zoomComboBox;
        }
        this.zoomComboBox = this.createZoomComboBox(bl, bl2);
        return this.zoomComboBox;
    }

    public String getZoomComboBoxToolTipText() {
        return this.lookupResource("JPrintPreviewPane.zoomComboBoxToolTipText");
    }

    public Action getZoomInAction() {
        if (this.zoomInAction != null) {
            return this.zoomInAction;
        }
        this.zoomInAction = this.createZoomInAction();
        return this.zoomInAction;
    }

    public JButton getZoomInButton() {
        if (this.zoomInButton != null) {
            return this.zoomInButton;
        }
        Action action = this.getZoomInAction();
        this.zoomInButton = this.createButton(action);
        return this.zoomInButton;
    }

    public Icon getZoomInIcon() {
        return this.loadIcon("toolbarButtonGraphics/general/ZoomIn16.gif", "toolbarButtonGraphics/general/ZoomIn24.gif");
    }

    public int getZoomInMnemonic() {
        return this.lookupMnemonic("JPrintPreviewPane.zoomInButtonMnemonic");
    }

    public String getZoomInText() {
        return this.lookupResource("JPrintPreviewPane.zoomInButtonText");
    }

    public String getZoomInToolTip() {
        return this.lookupResource("JPrintPreviewPane.zoomInButtonToolTipText");
    }

    public Action getZoomInToggleAction() {
        if (this.zoomInToggleAction != null) {
            return this.zoomInToggleAction;
        }
        this.zoomInToggleAction = this.createZoomInToggleAction();
        return this.zoomInToggleAction;
    }

    public JToggleButton getZoomInToggleButton() {
        if (this.zoomInToggleButton != null) {
            return this.zoomInToggleButton;
        }
        Action action = this.getZoomInToggleAction();
        this.zoomInToggleButton = this.createToggleButton(action);
        if (this.zoomInOutToggleGroup == null) {
            this.zoomInOutToggleGroup = new ButtonGroup();
        }
        this.zoomInOutToggleGroup.add(this.zoomInToggleButton);
        return this.zoomInToggleButton;
    }

    public Icon getZoomInToggleIcon() {
        return this.loadIcon("toolbarButtonGraphics/general/ZoomIn16.gif", "toolbarButtonGraphics/general/ZoomIn24.gif");
    }

    public int getZoomInToggleMnemonic() {
        return this.lookupMnemonic("JPrintPreviewPane.zoomInToggleButtonMnemonic");
    }

    public String getZoomInToggleText() {
        return this.lookupResource("JPrintPreviewPane.zoomInToggleButtonText");
    }

    public String getZoomInToggleToolTip() {
        return this.lookupResource("JPrintPreviewPane.zoomInToggleButtonToolTipText");
    }

    public List getZoomLayouts() {
        ArrayList<LayoutManager> arrayList = new ArrayList<LayoutManager>(7);
        JPrintPreviewPane jPrintPreviewPane = this.getPrintPreviewPane();
        PrintPreviewPaneUI printPreviewPaneUI = jPrintPreviewPane.getUI();
        arrayList.add(printPreviewPaneUI.createZoomLayout(jPrintPreviewPane, 4.0));
        arrayList.add(printPreviewPaneUI.createZoomLayout(jPrintPreviewPane, 2.0));
        arrayList.add(printPreviewPaneUI.createZoomLayout(jPrintPreviewPane, 1.5));
        arrayList.add(printPreviewPaneUI.createZoomLayout(jPrintPreviewPane, 1.0));
        arrayList.add(printPreviewPaneUI.createZoomLayout(jPrintPreviewPane, 0.75));
        arrayList.add(printPreviewPaneUI.createZoomLayout(jPrintPreviewPane, 0.5));
        arrayList.add(printPreviewPaneUI.createZoomLayout(jPrintPreviewPane, 0.25));
        return arrayList;
    }

    public Action getZoomOutAction() {
        if (this.zoomOutAction != null) {
            return this.zoomOutAction;
        }
        this.zoomOutAction = this.createZoomOutAction();
        return this.zoomOutAction;
    }

    public JButton getZoomOutButton() {
        if (this.zoomOutButton != null) {
            return this.zoomOutButton;
        }
        Action action = this.getZoomOutAction();
        this.zoomOutButton = this.createButton(action);
        return this.zoomOutButton;
    }

    public Icon getZoomOutIcon() {
        return this.loadIcon("toolbarButtonGraphics/general/ZoomOut16.gif", "toolbarButtonGraphics/general/ZoomOut24.gif");
    }

    public int getZoomOutMnemonic() {
        return this.lookupMnemonic("JPrintPreviewPane.zoomOutButtonMnemonic");
    }

    public String getZoomOutText() {
        return this.lookupResource("JPrintPreviewPane.zoomOutButtonText");
    }

    public String getZoomOutToolTip() {
        return this.lookupResource("JPrintPreviewPane.zoomOutButtonToolTipText");
    }

    public Action getZoomOutToggleAction() {
        if (this.zoomOutToggleAction != null) {
            return this.zoomOutToggleAction;
        }
        this.zoomOutToggleAction = this.createZoomOutToggleAction();
        return this.zoomOutToggleAction;
    }

    public JToggleButton getZoomOutToggleButton() {
        if (this.zoomOutToggleButton != null) {
            return this.zoomOutToggleButton;
        }
        Action action = this.getZoomOutToggleAction();
        this.zoomOutToggleButton = this.createToggleButton(action);
        if (this.zoomInOutToggleGroup == null) {
            this.zoomInOutToggleGroup = new ButtonGroup();
        }
        this.zoomInOutToggleGroup.add(this.zoomOutToggleButton);
        return this.zoomOutToggleButton;
    }

    public Icon getZoomOutToggleIcon() {
        return this.loadIcon("toolbarButtonGraphics/general/ZoomOut16.gif", "toolbarButtonGraphics/general/ZoomOut24.gif");
    }

    public int getZoomOutToggleMnemonic() {
        return this.lookupMnemonic("JPrintPreviewPane.zoomOutToggleButtonMnemonic");
    }

    public String getZoomOutToggleText() {
        return this.lookupResource("JPrintPreviewPane.zoomOutToggleButtonText");
    }

    public String getZoomOutToggleToolTip() {
        return this.lookupResource("JPrintPreviewPane.zoomOutToggleButtonToolTipText");
    }

    public Action getZoomToggleAction() {
        if (this.zoomToggleAction != null) {
            return this.zoomToggleAction;
        }
        this.zoomToggleAction = this.createZoomToggleAction();
        return this.zoomToggleAction;
    }

    public JToggleButton getZoomToggleButton() {
        if (this.zoomToggleButton != null) {
            return this.zoomToggleButton;
        }
        Action action = this.getZoomToggleAction();
        this.zoomToggleButton = this.createToggleButton(action);
        return this.zoomToggleButton;
    }

    public Icon getZoomToggleIcon() {
        return this.loadIcon("toolbarButtonGraphics/general/Zoom16.gif", "toolbarButtonGraphics/general/Zoom24.gif");
    }

    public int getZoomToggleMnemonic() {
        return this.lookupMnemonic("JPrintPreviewPane.zoomToggleButtonMnemonic");
    }

    public String getZoomToggleText() {
        return this.lookupResource("JPrintPreviewPane.zoomToggleButtonText");
    }

    public String getZoomToggleToolTip() {
        return this.lookupResource("JPrintPreviewPane.zoomToggleButtonToolTipText");
    }

    protected void handlePrinterException(PrinterException printerException) {
        JOptionPane.showMessageDialog(this.getPrintPreviewPane(), printerException.getLocalizedMessage(), this.lookupResource("JPrintPreviewPane.printErrorDialogTitle"), 0);
    }

    private Icon loadIcon(String string, String string2) {
        String string3 = this.getLargeIconsAreUsed() ? string2 : string;
        return Utility.loadIcon(this, string3);
    }

    private Icon loadOrientationDependentIcon(String string, String string2, String string3, String string4) {
        Locale locale = Locale.getDefault();
        ComponentOrientation componentOrientation = ComponentOrientation.getOrientation(locale);
        boolean bl = componentOrientation.isLeftToRight();
        String string5 = bl ? string : string3;
        String string6 = bl ? string2 : string4;
        String string7 = this.getLargeIconsAreUsed() ? string6 : string5;
        return Utility.loadIcon(this, string7);
    }

    private int lookupMnemonic(String string) {
        String string2 = this.lookupResource(string);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return 0;
    }

    private String lookupResource(String string) {
        return UIManager.getString(string);
    }

    private void setCurrentPageIndex(int n) {
        this.currentPageIndex = n;
        Pageable pageable = this.printPreviewPane.getPageable();
        int n2 = pageable.getNumberOfPages() - 1;
        if (this.firstPageAction != null) {
            this.firstPageAction.setEnabled(n > 0);
        }
        if (this.previousPageAction != null) {
            this.previousPageAction.setEnabled(n > 0);
        }
        if (this.lastPageAction != null) {
            this.lastPageAction.setEnabled(n < n2);
        }
        if (this.nextPageAction != null) {
            this.nextPageAction.setEnabled(n < n2);
        }
        if (this.pageField != null) {
            this.pageField.setValue(new Integer(n + 1));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     */
    static {
        block4: {
            PrintPreviewSupport.zoomFormat = NumberFormat.getPercentInstance();
            if (PrintPreviewSupport.zoomFormat instanceof DecimalFormat) {
                var0 = (DecimalFormat)PrintPreviewSupport.zoomFormat;
                var0.setMaximumFractionDigits(0);
            }
            var0 = UIManager.getDefaults();
            try {
                var1_1 = ResourceBundle.getBundle("sos.preview.PrintPreview", Locale.getDefault(), ClassLoader.getSystemClassLoader());
                var0.addResourceBundle("sos.preview.PrintPreview");
                break block4;
            }
            catch (Exception var1_2) {
                var2_3 = ResourceBundle.getBundle("sos.preview.PrintPreview", Locale.getDefault(), (PrintPreviewSupport.class$sos$preview$JPrintPreviewPane == null ? (PrintPreviewSupport.class$sos$preview$JPrintPreviewPane = PrintPreviewSupport.class$("sos.preview.JPrintPreviewPane")) : PrintPreviewSupport.class$sos$preview$JPrintPreviewPane).getClassLoader());
                var3_4 = var2_3.getKeys();
                ** while (var3_4.hasMoreElements())
            }
lbl-1000:
            // 1 sources

            {
                var4_5 = var3_4.nextElement();
                var5_6 = var2_3.getObject(var4_5);
                var0.put(var4_5, var5_6);
                continue;
            }
        }
    }

    public static interface PageableFactory {
        public Pageable createPageable(PageFormat var1);
    }

    class ZoomComboBoxEditor
    implements ComboBoxEditor {
        private JFormattedTextField textField;

        ZoomComboBoxEditor(JFormattedTextField.AbstractFormatter abstractFormatter) {
            this.textField = new JFormattedTextField(abstractFormatter);
        }

        public void addActionListener(ActionListener actionListener) {
            this.textField.addActionListener(actionListener);
        }

        public Component getEditorComponent() {
            return this.textField;
        }

        public Object getItem() {
            if (this.textField.isEditValid()) {
                return this.textField.getValue();
            }
            return null;
        }

        public void removeActionListener(ActionListener actionListener) {
            this.textField.removeActionListener(actionListener);
        }

        public void selectAll() {
            this.textField.selectAll();
            this.textField.requestFocus();
        }

        public void setItem(Object object) {
            this.textField.setValue(object);
        }
    }

    class ZoomFormatter
    extends JFormattedTextField.AbstractFormatter {
        private Map formatMap;

        ZoomFormatter(Map map) {
            this.formatMap = map;
        }

        public Object stringToValue(String string) throws ParseException {
            Collection collection = this.formatMap.values();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Format format = (Format)iterator.next();
                try {
                    Object object = format.parseObject(string);
                    if (object == null) continue;
                    return object;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            throw new ParseException(string, 0);
        }

        public String valueToString(Object object) throws ParseException {
            if (object == null) {
                return "";
            }
            Class<?> clazz = object.getClass();
            Format format = (Format)this.formatMap.get(clazz);
            String string = format == null ? String.valueOf(object) : format.format(object);
            return string;
        }
    }

    class LayoutCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private Map formatMap;

        LayoutCellRenderer(Map map) {
            this.formatMap = map;
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(1, 4, 1, 4));
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            LayoutManager layoutManager = (LayoutManager)object;
            Class<?> clazz = layoutManager.getClass();
            Format format = (Format)this.formatMap.get(clazz);
            String string = format == null ? String.valueOf(object) : format.format(object);
            this.setText(string);
            this.setFont(jList.getFont());
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }
    }

    protected class ZoomToggleAction
    extends AbstractAction {
        protected ZoomToggleAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = PrintPreviewSupport.this.printPreviewPane.getMode();
            if (n == 1) {
                PrintPreviewSupport.this.printPreviewPane.setMode(0);
            } else {
                PrintPreviewSupport.this.printPreviewPane.setMode(1);
            }
        }
    }

    protected class ZoomOutToggleAction
    extends AbstractAction {
        protected ZoomOutToggleAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (!(object instanceof AbstractButton)) {
                return;
            }
            AbstractButton abstractButton = (AbstractButton)object;
            if (abstractButton.isSelected()) {
                PrintPreviewSupport.this.printPreviewPane.setMode(3);
            } else {
                PrintPreviewSupport.this.printPreviewPane.setMode(0);
            }
        }
    }

    protected class ZoomOutAction
    extends AbstractAction {
        protected ZoomOutAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PrintPreviewSupport.this.printPreviewPane.zoomOut();
        }
    }

    protected class ZoomInToggleAction
    extends AbstractAction {
        protected ZoomInToggleAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (!(object instanceof AbstractButton)) {
                return;
            }
            AbstractButton abstractButton = (AbstractButton)object;
            if (abstractButton.isSelected()) {
                PrintPreviewSupport.this.printPreviewPane.setMode(2);
            } else {
                PrintPreviewSupport.this.printPreviewPane.setMode(0);
            }
        }
    }

    protected class ZoomInAction
    extends AbstractAction {
        protected ZoomInAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PrintPreviewSupport.this.printPreviewPane.zoomIn();
        }
    }

    protected class PrintAllAction
    extends AbstractAction {
        protected PrintAllAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                PrintPreviewSupport.this.printPreviewPane.printAll();
                if (PrintPreviewSupport.this.closeAction != null) {
                    PrintPreviewSupport.this.closeAction.actionPerformed(null);
                }
            }
            catch (PrinterException printerException) {
                PrintPreviewSupport.this.handlePrinterException(printerException);
            }
        }
    }

    protected class PrintAction
    extends AbstractAction {
        protected PrintAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                PrintPreviewSupport.this.printPreviewPane.print();
            }
            catch (PrinterException printerException) {
                PrintPreviewSupport.this.handlePrinterException(printerException);
            }
        }
    }

    protected class PreviousPageAction
    extends AbstractAction {
        protected PreviousPageAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (PrintPreviewSupport.this.currentPageIndex <= 0) {
                return;
            }
            PrintPreviewSupport.this.setCurrentPageIndex(PrintPreviewSupport.this.currentPageIndex - 1);
            PrintPreviewSupport.this.printPreviewPane.centerPage(PrintPreviewSupport.this.currentPageIndex);
        }
    }

    protected class PageSetupAction
    extends AbstractAction {
        protected PageSetupAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PageFormat pageFormat;
            JPrintPreviewPane jPrintPreviewPane = PrintPreviewSupport.this.getPrintPreviewPane();
            Pageable pageable = jPrintPreviewPane.getPageable();
            int n = pageable.getNumberOfPages();
            if (n <= 0) {
                return;
            }
            int n2 = jPrintPreviewPane.getSelectedPageIndex();
            if (n2 < 0) {
                n2 = 0;
            }
            if ((pageFormat = jPrintPreviewPane.pageSetup(n2)) == null) {
                return;
            }
            PageableFactory pageableFactory = PrintPreviewSupport.this.getPageableFactory();
            if (pageableFactory == null) {
                return;
            }
            Pageable pageable2 = pageableFactory.createPageable(pageFormat);
            jPrintPreviewPane.setPageable(pageable2);
        }
    }

    protected class NextPageAction
    extends AbstractAction {
        protected NextPageAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Pageable pageable = PrintPreviewSupport.this.printPreviewPane.getPageable();
            int n = pageable.getNumberOfPages();
            if (PrintPreviewSupport.this.currentPageIndex >= n - 1) {
                return;
            }
            PrintPreviewSupport.this.setCurrentPageIndex(PrintPreviewSupport.this.currentPageIndex + 1);
            PrintPreviewSupport.this.printPreviewPane.centerPage(PrintPreviewSupport.this.currentPageIndex);
        }
    }

    protected class LastPageAction
    extends AbstractAction {
        protected LastPageAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Pageable pageable = PrintPreviewSupport.this.printPreviewPane.getPageable();
            int n = pageable.getNumberOfPages();
            if (PrintPreviewSupport.this.currentPageIndex >= n - 1) {
                return;
            }
            PrintPreviewSupport.this.setCurrentPageIndex(n - 1);
            PrintPreviewSupport.this.printPreviewPane.centerPage(PrintPreviewSupport.this.currentPageIndex);
        }
    }

    protected class FirstPageAction
    extends AbstractAction {
        protected FirstPageAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (PrintPreviewSupport.this.currentPageIndex <= 0) {
                return;
            }
            PrintPreviewSupport.this.setCurrentPageIndex(0);
            PrintPreviewSupport.this.printPreviewPane.centerPage(PrintPreviewSupport.this.currentPageIndex);
        }
    }
}

