/*
 * Decompiled with CFR 0.152.
 */
package sos.preview;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.List;
import sos.preview.BasicPrintPreviewPageUI;
import sos.preview.Utility;

public class PageableAdapter
implements Pageable {
    private PageFormat pageFormat;
    private List images;
    private Printable printable;

    public PageableAdapter(Printable printable, PageFormat pageFormat) throws PrinterException {
        Utility.checkNull(pageFormat, "pageFormat");
        this.pageFormat = pageFormat;
        this.images = new ArrayList();
        int n = (int)pageFormat.getImageableWidth();
        int n2 = (int)pageFormat.getImageableHeight();
        int n3 = 0;
        while (true) {
            BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.addRenderingHints(BasicPrintPreviewPageUI.hints);
            int n4 = printable.print(graphics2D, pageFormat, n3);
            if (n4 != 0) break;
            this.images.add(bufferedImage);
            ++n3;
        }
        this.printable = new PagePrintable();
    }

    public int getNumberOfPages() {
        return this.images.size();
    }

    public PageFormat getPageFormat(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.images.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.pageFormat;
    }

    public Printable getPrintable(int n) throws IndexOutOfBoundsException {
        return this.printable;
    }

    class PagePrintable
    implements Printable {
        PagePrintable() {
        }

        public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
            if (n < 0 || n >= PageableAdapter.this.images.size()) {
                return 1;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            int n2 = (int)pageFormat.getImageableX();
            int n3 = (int)pageFormat.getImageableY();
            BufferedImage bufferedImage = (BufferedImage)PageableAdapter.this.images.get(n);
            graphics2D.drawImage(bufferedImage, null, n2, n3);
            return 0;
        }
    }
}

