/*
 * Decompiled with CFR 0.152.
 */
package sos.preview;

import java.text.Collator;
import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.UIManager;
import sos.preview.BasicPrintPreviewPaneUI;
import sos.preview.MatrixLayout;

public class MatrixLayoutFormat
extends Format {
    private Collator collator;
    private NumberFormat rowFormat;
    private NumberFormat columnFormat;

    public MatrixLayoutFormat() {
        this(NumberFormat.getNumberInstance(), NumberFormat.getNumberInstance(), Collator.getInstance());
    }

    public MatrixLayoutFormat(Locale locale) {
        this(NumberFormat.getNumberInstance(locale), NumberFormat.getNumberInstance(locale), Collator.getInstance(locale));
    }

    private MatrixLayoutFormat(NumberFormat numberFormat, NumberFormat numberFormat2, Collator collator) {
        this.rowFormat = numberFormat;
        this.columnFormat = numberFormat2;
        this.collator = collator;
        collator.setStrength(1);
    }

    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        String string;
        if (!(object instanceof MatrixLayout)) {
            throw new IllegalArgumentException("Cannot format object.");
        }
        MatrixLayout matrixLayout = (MatrixLayout)object;
        int n = matrixLayout.getRowCount();
        int n2 = matrixLayout.getColumnCount();
        if (n == 1 && n2 == 1) {
            string = UIManager.getString("JPrintPreviewPane.onePageLayoutName");
        } else if (n == 1 && n2 == 2) {
            string = UIManager.getString("JPrintPreviewPane.twoPageLayoutName");
        } else {
            String string2 = UIManager.getString("JPrintPreviewPane.matrixLayoutName");
            Object[] objectArray = new Object[]{new Integer(n), new Integer(n2)};
            string = MessageFormat.format(string2, objectArray);
        }
        stringBuffer.append(string);
        return stringBuffer;
    }

    public static Locale[] getAvailableLocales() {
        return new Locale[]{Locale.US};
    }

    public static MatrixLayoutFormat getInstance() {
        return new MatrixLayoutFormat();
    }

    public static MatrixLayoutFormat getInstance(Locale locale) {
        return new MatrixLayoutFormat(locale);
    }

    public Object parseObject(String string, ParsePosition parsePosition) {
        Pattern pattern;
        Matcher matcher;
        String string2 = UIManager.getString("JPrintPreviewPane.onePageLayoutName");
        String string3 = UIManager.getString("JPrintPreviewPane.twoPageLayoutName");
        if (string2 != null && this.collator.compare(string2, string) == 0) {
            parsePosition.setIndex(string.length());
            return this.createLayout(1, 1);
        }
        if (string3 != null && this.collator.compare(string3, string) == 0) {
            parsePosition.setIndex(string.length());
            return this.createLayout(1, 2);
        }
        String string4 = UIManager.getString("JPrintPreviewPane.matrixLayoutRegularExpression");
        if (string4 != null && (matcher = (pattern = Pattern.compile(string4)).matcher(string)).matches()) {
            String string5 = matcher.group(1);
            String string6 = matcher.group(3);
            int n = Integer.parseInt(string5);
            int n2 = Integer.parseInt(string6);
            if (n > 0 && n2 > 0) {
                parsePosition.setIndex(string.length());
                return this.createLayout(n, n2);
            }
        }
        return null;
    }

    private MatrixLayout createLayout(int n, int n2) {
        int n3 = UIManager.getInt(BasicPrintPreviewPaneUI.HORIZONTAL_ALIGNMENT);
        int n4 = UIManager.getInt(BasicPrintPreviewPaneUI.VERTICAL_ALIGNMENT);
        int n5 = UIManager.getInt(BasicPrintPreviewPaneUI.HORIZONTAL_SPACING);
        int n6 = UIManager.getInt(BasicPrintPreviewPaneUI.VERTICAL_SPACING);
        int n7 = UIManager.getInt(BasicPrintPreviewPaneUI.LEFT_MARGIN);
        int n8 = UIManager.getInt(BasicPrintPreviewPaneUI.RIGHT_MARGIN);
        int n9 = UIManager.getInt(BasicPrintPreviewPaneUI.TOP_MARGIN);
        int n10 = UIManager.getInt(BasicPrintPreviewPaneUI.BOTTOM_MARGIN);
        return new MatrixLayout(n, n2, n3, n4, n5, n6, n7, n8, n9, n10);
    }
}

