/*
 * Decompiled with CFR 0.152.
 */
package sos.preview;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;
import sos.preview.LayoutSupport;
import sos.preview.ScalingLayoutManager;
import sos.preview.ScrollableLayoutManager;
import sos.preview.Utility;

public class MatrixLayout
implements ScrollableLayoutManager,
ScalingLayoutManager,
Serializable {
    private static final int DEFAULT_HORIZONTAL_SPACING = 10;
    private static final int DEFAULT_VERTICAL_SPACING = 10;
    private static final int DEFAULT_MINIMUM_LEFT_MARGIN = 10;
    private static final int DEFAULT_MINIMUM_RIGHT_MARGIN = 10;
    private static final int DEFAULT_MINIMUM_TOP_MARGIN = 10;
    private static final int DEFAULT_MINIMUM_BOTTOM_MARGIN = 10;
    private static final int DEFAULT_HORIZONTAL_ALIGNMENT = 0;
    private static final int DEFAULT_VERTICAL_ALIGNMENT = 0;
    private int numColumns;
    private int numRows;
    private int minLeftMargin;
    private int minRightMargin;
    private int minTopMargin;
    private int minBottomMargin;
    private int horizontalSpacing;
    private int verticalSpacing;
    private int horizontalAlignment;
    private int verticalAlignment;

    public MatrixLayout(int n, int n2) throws IllegalArgumentException {
        this(n, n2, 0, 0, 10, 10, 10, 10, 10, 10);
    }

    public MatrixLayout(int n, int n2, int n3, int n4) throws IllegalArgumentException {
        this(n, n2, n3, n4, 10, 10, 10, 10, 10, 10);
    }

    public MatrixLayout(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) throws IllegalArgumentException {
        this(n, n2, 0, 0, n3, n4, n5, n6, n7, n8);
    }

    public MatrixLayout(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) throws IllegalArgumentException {
        if (n < 1) {
            throw new IllegalArgumentException("numRows must be greater than 0");
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("numColumns must be greater than 0");
        }
        Utility.checkHorizontalAlignment(n3);
        Utility.checkVerticalAlignment(n4);
        Utility.checkSpacing(n5, n6);
        Utility.checkMargins(n7, n8, n9, n10);
        this.numRows = n;
        this.numColumns = n2;
        this.horizontalAlignment = n3;
        this.verticalAlignment = n4;
        this.horizontalSpacing = n5;
        this.verticalSpacing = n6;
        this.minLeftMargin = n7;
        this.minRightMargin = n8;
        this.minTopMargin = n9;
        this.minBottomMargin = n10;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    private double doScaleComponents(Container container, boolean bl) {
        int n;
        int n2;
        Container container2 = container.getParent();
        Dimension dimension = container2.getSize();
        Insets insets = container.getInsets();
        int n3 = (int)dimension.getWidth() - insets.left - insets.right;
        int n4 = (int)dimension.getHeight() - insets.top - insets.bottom;
        int n5 = container.getComponentCount();
        if (n5 == 0) {
            return 1.0;
        }
        LayoutSupport layoutSupport = LayoutSupport.getSupport(container);
        double d = layoutSupport.getMaximumFixedWidth();
        double d2 = layoutSupport.getMaximumFixedHeight();
        double d3 = layoutSupport.getMaximumPreferredScaleableWidth();
        double d4 = layoutSupport.getMaximumPreferredScaleableHeight();
        double d5 = ((double)(n3 - this.minLeftMargin - this.minRightMargin - (this.numColumns - 1) * this.horizontalSpacing) - (double)this.numColumns * d) / (double)this.numColumns;
        double d6 = ((double)(n4 - this.minTopMargin - this.minBottomMargin - (this.numRows - 1) * this.verticalSpacing) - (double)this.numRows * d2) / (double)this.numRows;
        double d7 = d5 / d3;
        double d8 = d6 / d4;
        double d9 = Math.min(d7, d8);
        if (!bl) {
            return d9;
        }
        double d10 = d2 + d4 * d9;
        double d11 = d + d3 * d9;
        int n6 = (int)(((double)n4 - (double)this.numRows * d10 - (double)((this.numRows - 1) * this.verticalSpacing)) / 2.0);
        double d12 = (double)(2 * n6) + (double)this.numRows * d10 + (double)((this.numRows - 1) * this.verticalSpacing);
        int n7 = n5 / (this.numColumns * this.numRows);
        if (n5 % (this.numColumns * this.numRows) != 0) {
            ++n7;
        }
        double d13 = d12 * (double)n7;
        int n8 = n3 - this.numColumns * (int)d11 - (this.numColumns - 1) * this.horizontalSpacing - this.minLeftMargin - this.minRightMargin;
        int n9 = n2 = n8 / 2;
        if (n8 % 2 != 0) {
            ++n9;
        }
        int n10 = this.minLeftMargin + n2;
        int n11 = this.minRightMargin + n9;
        int n12 = n4 - this.numRows * (int)d10 - (this.numRows - 1) * this.verticalSpacing - this.minTopMargin - this.minBottomMargin;
        int n13 = n = n12 / 2;
        if (n12 % 2 != 0) {
            ++n13;
        }
        int n14 = this.minTopMargin + n;
        int n15 = this.minBottomMargin + n13;
        layoutSupport.layoutComponents(this.numRows, this.numColumns, (int)d11, (int)d10, d9, this.horizontalSpacing, this.verticalSpacing, n10, n11, n14, n15, this.horizontalAlignment, this.verticalAlignment);
        return d9;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MatrixLayout)) {
            return false;
        }
        MatrixLayout matrixLayout = (MatrixLayout)object;
        return this.getRowCount() == matrixLayout.getRowCount() && this.getColumnCount() == matrixLayout.getColumnCount() && this.minLeftMargin == matrixLayout.minLeftMargin && this.minRightMargin == matrixLayout.minRightMargin && this.minTopMargin == matrixLayout.minTopMargin && this.minBottomMargin == matrixLayout.minBottomMargin && this.horizontalSpacing == matrixLayout.horizontalSpacing && this.verticalSpacing == matrixLayout.verticalSpacing && this.horizontalAlignment == matrixLayout.horizontalAlignment && this.verticalAlignment == matrixLayout.verticalAlignment;
    }

    public int getColumnCount() {
        return this.numColumns;
    }

    public Dimension getPreferredScrollableViewportSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public int hashCode() {
        return this.getRowCount() * 31 + this.getColumnCount() * 31 + Utility.computeHashCode(this.horizontalAlignment, this.verticalAlignment, this.horizontalSpacing, this.verticalSpacing, this.minLeftMargin, this.minRightMargin, this.minTopMargin, this.minBottomMargin);
    }

    public double preferredScale(Container container) {
        Container container2 = container.getParent();
        if (container2 == null) {
            return 0.0;
        }
        Dimension dimension = container2.getSize();
        double d = dimension.getWidth();
        double d2 = dimension.getHeight();
        if (d == 0.0 || d2 == 0.0) {
            return 1.0;
        }
        Insets insets = container2.getInsets();
        double d3 = dimension.getWidth() - (double)insets.left - (double)insets.right;
        double d4 = dimension.getHeight() - (double)insets.top - (double)insets.bottom;
        int n = container.getComponentCount();
        if (n == 0) {
            return 1.0;
        }
        LayoutSupport layoutSupport = LayoutSupport.getSupport(container);
        double d5 = layoutSupport.getMaximumFixedWidth();
        double d6 = layoutSupport.getMaximumFixedHeight();
        double d7 = layoutSupport.getMaximumPreferredScaleableWidth();
        double d8 = layoutSupport.getMaximumPreferredScaleableHeight();
        double d9 = (d3 - (double)this.minLeftMargin - (double)this.minRightMargin - (double)((this.numColumns - 1) * this.horizontalSpacing) - (double)this.numColumns * d5) / (double)this.numColumns;
        double d10 = (d4 - (double)this.minTopMargin - (double)this.minBottomMargin - (double)((this.numRows - 1) * this.verticalSpacing) - (double)this.numRows * d6) / (double)this.numRows;
        double d11 = d9 / d7;
        double d12 = d10 / d8;
        double d13 = Math.min(d11, d12);
        return d13;
    }

    public int getRowCount() {
        return this.numRows;
    }

    public int getScrollableBlockIncrement(Container container, Rectangle rectangle, int n, int n2) {
        if (n == 0) {
            int n3 = rectangle.x % rectangle.width;
            if (n3 == 0) {
                return rectangle.width;
            }
            if (n2 < 0) {
                return n3;
            }
            return rectangle.width - n3;
        }
        int n4 = rectangle.y % rectangle.height;
        if (n4 == 0) {
            return rectangle.height;
        }
        if (n2 < 0) {
            return n4;
        }
        return rectangle.height - n4;
    }

    public boolean getScrollableTracksViewportHeight(Container container) {
        ComponentOrientation componentOrientation = container.getComponentOrientation();
        return !componentOrientation.isHorizontal();
    }

    public boolean getScrollableTracksViewportWidth(Container container) {
        ComponentOrientation componentOrientation = container.getComponentOrientation();
        return componentOrientation.isHorizontal();
    }

    public int getScrollableUnitIncrement(Container container, Rectangle rectangle, int n, int n2) {
        return this.getScrollableBlockIncrement(container, rectangle, n, n2);
    }

    private Dimension idealPreferredLayoutSize(Container container) {
        LayoutSupport layoutSupport = LayoutSupport.getSupport(container);
        return layoutSupport.getDimensions(1.0, this.numRows, this.numColumns, this.horizontalSpacing, this.verticalSpacing, this.minLeftMargin, this.minRightMargin, this.minTopMargin, this.minBottomMargin);
    }

    public void layoutContainer(Container container) {
        this.scaleComponents(container);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public Dimension preferredLayoutSize(Container container) {
        Container container2 = container.getParent();
        if (container2 == null) {
            return new Dimension(0, 0);
        }
        Dimension dimension = container2.getSize();
        double d = dimension.getWidth();
        double d2 = dimension.getHeight();
        if (d == 0.0 || d2 == 0.0) {
            return this.idealPreferredLayoutSize(container);
        }
        Insets insets = container2.getInsets();
        double d3 = dimension.getWidth() - (double)insets.left - (double)insets.right;
        double d4 = dimension.getHeight() - (double)insets.top - (double)insets.bottom;
        int n = container.getComponentCount();
        if (n == 0) {
            return dimension;
        }
        LayoutSupport layoutSupport = LayoutSupport.getSupport(container);
        double d5 = layoutSupport.getMaximumFixedWidth();
        double d6 = layoutSupport.getMaximumFixedHeight();
        double d7 = layoutSupport.getMaximumPreferredScaleableWidth();
        double d8 = layoutSupport.getMaximumPreferredScaleableHeight();
        double d9 = (d3 - (double)this.minLeftMargin - (double)this.minRightMargin - (double)((this.numColumns - 1) * this.horizontalSpacing) - (double)this.numColumns * d5) / (double)this.numColumns;
        double d10 = (d4 - (double)this.minTopMargin - (double)this.minBottomMargin - (double)((this.numRows - 1) * this.verticalSpacing) - (double)this.numRows * d6) / (double)this.numRows;
        double d11 = d9 / d7;
        double d12 = d10 / d8;
        double d13 = Math.min(d11, d12);
        double d14 = d6 + d8 * d13;
        int n2 = (int)((d4 - (double)this.numRows * d14 - (double)((this.numRows - 1) * this.verticalSpacing)) / 2.0);
        double d15 = (double)(2 * n2) + (double)this.numRows * d14 + (double)((this.numRows - 1) * this.verticalSpacing);
        int n3 = n / (this.numColumns * this.numRows);
        if (n % (this.numColumns * this.numRows) != 0) {
            ++n3;
        }
        double d16 = d15 * (double)n3;
        return new Dimension((int)d3, (int)d16);
    }

    public void removeLayoutComponent(Component component) {
    }

    public double scaleComponents(Container container) {
        return this.doScaleComponents(container, true);
    }
}

