/*
 * Decompiled with CFR 0.152.
 */
package sos.preview;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import sos.preview.Scaleable;

class LayoutSupport {
    private Container container;
    private double maxComponentFixedWidth;
    private double maxComponentFixedHeight;
    private double maxComponentScaledWidth;
    private double maxComponentScaledHeight;
    private double[] fixedWidth;
    private double[] fixedHeight;
    private double[] scaledWidth;
    private double[] scaledHeight;

    private LayoutSupport(Container container) {
        this.container = container;
        Component[] componentArray = container.getComponents();
        int n = componentArray.length;
        this.fixedWidth = new double[n];
        this.fixedHeight = new double[n];
        this.scaledWidth = new double[n];
        this.scaledHeight = new double[n];
        this.maxComponentFixedWidth = 0.0;
        this.maxComponentFixedHeight = 0.0;
        this.maxComponentScaledWidth = 0.0;
        this.maxComponentScaledHeight = 0.0;
        int n2 = 0;
        while (n2 < n) {
            double d;
            double d2;
            double d3;
            double d4;
            Cloneable cloneable;
            Object object;
            Component component = componentArray[n2];
            if (component instanceof Scaleable) {
                object = (Scaleable)((Object)component);
                cloneable = object.getScaleablePreferredSize();
                d4 = ((Dimension)cloneable).getWidth();
                d3 = ((Dimension)cloneable).getHeight();
                d2 = object.getFixedWidth();
                d = object.getFixedHeight();
            } else if (component instanceof Container) {
                object = (Container)component;
                cloneable = ((Container)object).getInsets();
                d2 = ((Insets)cloneable).left + ((Insets)cloneable).right;
                d = ((Insets)cloneable).top + ((Insets)cloneable).bottom;
                Dimension dimension = ((Container)object).getPreferredSize();
                d4 = dimension.getWidth() - d2;
                d3 = dimension.getHeight() - d;
            } else {
                d2 = 0.0;
                d = 0.0;
                object = component.getPreferredSize();
                d4 = ((Dimension)object).getWidth();
                d3 = ((Dimension)object).getHeight();
            }
            this.fixedWidth[n2] = d2;
            this.fixedHeight[n2] = d;
            this.scaledWidth[n2] = d4;
            this.scaledHeight[n2] = d3;
            this.maxComponentFixedWidth = Math.max(this.maxComponentFixedWidth, d2);
            this.maxComponentFixedHeight = Math.max(this.maxComponentFixedHeight, d);
            this.maxComponentScaledWidth = Math.max(this.maxComponentScaledWidth, d4);
            this.maxComponentScaledHeight = Math.max(this.maxComponentScaledHeight, d3);
            ++n2;
        }
    }

    Dimension getPreferredLayoutSize(int n, int n2, int n3, int n4, int n5, int n6) {
        double d = this.maxComponentFixedWidth + this.maxComponentScaledWidth;
        double d2 = this.maxComponentScaledHeight + this.maxComponentScaledHeight;
        int n7 = this.container.getComponentCount();
        double d3 = (double)(2 * n5) + (double)n7 * d + (double)((n7 - 1) * n3);
        double d4 = (double)(2 * n6) + d2;
        return new Dimension((int)d3, (int)d4);
    }

    static LayoutSupport getSupport(Container container) {
        return new LayoutSupport(container);
    }

    double getMaximumFixedHeight() {
        return this.maxComponentFixedHeight;
    }

    double getMaximumFixedWidth() {
        return this.maxComponentFixedWidth;
    }

    double getMaximumPreferredScaleableHeight() {
        return this.maxComponentScaledHeight;
    }

    double getMaximumPreferredScaleableWidth() {
        return this.maxComponentScaledWidth;
    }

    Dimension getDimensions(double d, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9;
        int n10;
        double d2 = this.maxComponentFixedWidth + this.maxComponentScaledWidth * d;
        double d3 = this.maxComponentFixedHeight + this.maxComponentScaledHeight * d;
        int n11 = this.container.getComponentCount();
        int n12 = n * n2;
        int n13 = n11 / n12;
        if (n11 % n12 != 0) {
            ++n13;
        }
        int n14 = (int)((double)n5 + (double)n2 * d2 + (double)((n2 - 1) * n3) + (double)n6);
        int n15 = (int)((double)n7 + (double)n * d3 + (double)((n - 1) * n4));
        ComponentOrientation componentOrientation = this.container.getComponentOrientation();
        if (componentOrientation.isHorizontal()) {
            n10 = n14;
            n9 = n15 * n13;
        } else {
            n10 = n14 * n13;
            n9 = n15;
        }
        Insets insets = this.container.getInsets();
        int n16 = n10 + insets.left + insets.right;
        int n17 = n9 + insets.top + insets.bottom;
        return new Dimension(n16, n17);
    }

    Dimension getLinearDimensions(double d, int n, int n2, int n3, int n4, int n5, int n6) {
        double d2;
        double d3;
        double d4 = this.maxComponentFixedWidth + this.maxComponentScaledWidth * d;
        double d5 = this.maxComponentFixedHeight + this.maxComponentScaledHeight * d;
        int n7 = this.container.getComponentCount();
        ComponentOrientation componentOrientation = this.container.getComponentOrientation();
        if (componentOrientation.isHorizontal()) {
            d3 = (double)(n3 + n4) + (double)n7 * d4 + (double)((n7 - 1) * n);
            d2 = (double)(n5 + n6) + d5;
        } else {
            d3 = (double)(n3 + n4) + d4;
            d2 = (double)(n5 + n6) + (double)n7 * d5 + (double)((n7 - 1) * n2);
        }
        Insets insets = this.container.getInsets();
        int n8 = (int)d3 + insets.left + insets.right;
        int n9 = (int)d2 + insets.top + insets.bottom;
        return new Dimension(n8, n9);
    }

    void layoutComponents(int n, int n2, int n3, int n4, double d, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
        Component[] componentArray = this.container.getComponents();
        int n13 = componentArray.length;
        if (n13 == 0) {
            return;
        }
        ComponentOrientation componentOrientation = this.container.getComponentOrientation();
        Insets insets = this.container.getInsets();
        int n14 = n * n2;
        int n15 = n13 / n14;
        if (n2 % n14 != 0) {
            ++n15;
        }
        int n16 = n7 + n8 + n2 * n3 + (n2 - 1) * n5;
        int n17 = n9 + n10 + n * n4 + (n - 1) * n6;
        boolean bl = componentOrientation.isLeftToRight();
        boolean bl2 = componentOrientation.isHorizontal();
        int n18 = 0;
        while (n18 < n13) {
            int n19;
            int n20;
            int n21;
            int n22;
            if (bl) {
                if (bl2) {
                    n22 = n18 / n14;
                    n21 = 0;
                    n20 = n18 % n14 / n2;
                    n19 = n18 % n2;
                } else {
                    n22 = 0;
                    n21 = n18 / n14;
                    n20 = n18 % n;
                    n19 = n18 % n14 / n;
                }
            } else if (bl2) {
                n22 = n18 / n14;
                n21 = 0;
                n20 = n18 % n14 / n2;
                n19 = n2 - n18 % n2 - 1;
            } else {
                n22 = 0;
                n21 = n15 - n18 / n14 - 1;
                n20 = n18 % n;
                n19 = n2 - n18 % n14 / n - 1;
            }
            int n23 = insets.left + n21 * n16 + n7 + n19 * n3 + n19 * n5;
            int n24 = insets.top + n22 * n17 + n10 + n20 * n4 + n20 * n6;
            Component component = componentArray[n18];
            double d2 = this.fixedWidth[n18];
            double d3 = this.fixedHeight[n18];
            double d4 = this.scaledWidth[n18];
            double d5 = this.scaledHeight[n18];
            int n25 = (int)(d2 + d4 * d);
            int n26 = (int)(d3 + d5 * d);
            int n27 = n23;
            switch (n11) {
                case 2: {
                    break;
                }
                case 0: {
                    n27 += (n3 - n25) / 2;
                    break;
                }
                case 4: {
                    n27 += n3 - n25;
                    break;
                }
                case 10: {
                    if (bl) break;
                    n27 += n3 - n25;
                    break;
                }
                case 11: {
                    if (!bl) break;
                    n27 += n3 - n25;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Invalid horizontal alignment: " + n11));
                }
            }
            int n28 = n24;
            switch (n12) {
                case 1: {
                    break;
                }
                case 0: {
                    n28 += (n4 - n26) / 2;
                    break;
                }
                case 3: {
                    n28 += n4 - n26;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Invalid vertical alignment: " + n12));
                }
            }
            component.setBounds(n27, n28, n25, n26);
            ++n18;
        }
    }
}

