/*
 * Decompiled with CFR 0.152.
 */
package sos.preview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.LinkedList;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.ListSelectionModel;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import sos.preview.AccessiblePrintPreviewRole;
import sos.preview.DefaultPageNumberRenderer;
import sos.preview.DefaultZoomFunction;
import sos.preview.JPrintPreviewPage;
import sos.preview.MatrixLayout;
import sos.preview.PageNumberRenderer;
import sos.preview.PrintPreviewPaneUI;
import sos.preview.ScalingLayoutManager;
import sos.preview.ScrollableLayoutManager;
import sos.preview.Utility;
import sos.preview.ZoomFunction;

public class JPrintPreviewPane
extends JComponent
implements Accessible,
Scrollable {
    private static final String uiClassID = "PrintPreviewPaneUI";
    public static final int SELECTION_MODE = 0;
    public static final int ZOOM_MODE = 1;
    public static final int ZOOM_IN_MODE = 2;
    public static final int ZOOM_OUT_MODE = 3;
    public static final String LAYOUT_PROPERTY = "layout";
    public static final String MARGINS_ARE_SHOWN_PROPERTY = "marginsAreShown";
    public static final String MODE_PROPERTY = "mode";
    public static final String PAGEABLE_PROPERTY = "pageable";
    public static final String PAGE_NUMBER_RENDERER_PROPERTY = "pageNumberRenderer";
    public static final String PAGE_NUMBERS_ARE_SHOWN_PROPERTY = "pageNumbersAreShown";
    public static final String PAGE_SELECTION_ALLOWED_PROPERTY = "pageSelectionAllowed";
    public static final String SCALE_PROPERTY = "scale";
    public static final String SELECTION_BACKGROUND_PROPERTY = "selectionBackground";
    public static final String SELECTION_FOREGROUND_PROPERTY = "selectionForeground";
    public static final String SELECTION_MODEL_PROPERTY = "selectionModel";
    public static final String ZOOM_FUNCTION_PROPERTY = "zoomFunctionProperty";
    private Pageable pageable;
    private PageNumberRenderer pageNumberRenderer;
    private boolean pageNumbersAreShown;
    private boolean marginsAreShown;
    private ListSelectionModel selectionModel;
    private int mode;
    private Color selectionBackground;
    private Color selectionForeground;
    private double scale;
    private boolean pageSelectionAllowed;
    private ZoomFunction zoomFunction;
    private LinkedList zoomStack = new LinkedList();
    private int zoomIndex;

    public JPrintPreviewPane() {
        this(new Book());
    }

    public JPrintPreviewPane(Pageable pageable) throws NullPointerException {
        this(pageable, new MatrixLayout(1, 1));
    }

    public JPrintPreviewPane(Pageable pageable, LayoutManager layoutManager) throws NullPointerException {
        Utility.checkNull(pageable, PAGEABLE_PROPERTY);
        this.pageable = pageable;
        this.setDoubleBuffered(true);
        this.installChildren();
        this.setLayout(layoutManager);
        this.selectionModel = this.createPageSelectionModel();
        this.pageNumberRenderer = this.createPageNumberRenderer();
        this.mode = 0;
        this.pageSelectionAllowed = true;
        this.pageNumbersAreShown = true;
        this.setOpaque(true);
        this.zoomFunction = this.createDefaultZoomFunction();
        this.updateUI();
    }

    private Point calculateCenter() {
        Rectangle rectangle = this.getVisibleRect();
        double d = rectangle.getCenterX();
        double d2 = rectangle.getCenterY();
        return new Point((int)d, (int)d2);
    }

    public void centerPage(int n) throws IllegalArgumentException {
        Rectangle rectangle;
        Component component = this.getPageComponent(n);
        Rectangle rectangle2 = this.getVisibleRect();
        double d = rectangle2.getWidth();
        double d2 = rectangle2.getHeight();
        LayoutManager layoutManager = this.getLayout();
        if (Utility.isOnePageLayout(layoutManager)) {
            rectangle = this.getComponentOrientation().isHorizontal() ? new Rectangle(0, (int)((double)n * d2), (int)d, (int)d2) : new Rectangle((int)((double)n * d), 0, (int)d, (int)d2);
        } else {
            Rectangle rectangle3 = component.getBounds();
            double d3 = rectangle3.getCenterX();
            double d4 = rectangle3.getCenterY();
            double d5 = d3 - d / 2.0;
            double d6 = d4 - d2 / 2.0;
            rectangle = new Rectangle((int)d5, (int)d6, (int)d, (int)d2);
        }
        this.scrollRectToVisible(rectangle);
    }

    protected ZoomFunction createDefaultZoomFunction() {
        return new DefaultZoomFunction();
    }

    protected Component createPageComponent(Printable printable, PageFormat pageFormat, int n) {
        return new JPrintPreviewPage(this, printable, pageFormat, n);
    }

    protected PageNumberRenderer createPageNumberRenderer() {
        return new DefaultPageNumberRenderer();
    }

    protected ListSelectionModel createPageSelectionModel() {
        return new DefaultListSelectionModel();
    }

    private LayoutManager createZoomLayout(double d) {
        PrintPreviewPaneUI printPreviewPaneUI = this.getUI();
        return printPreviewPaneUI.createZoomLayout(this, d);
    }

    public void doLayout() {
        double d;
        LayoutManager layoutManager = this.getLayout();
        if (layoutManager instanceof ScalingLayoutManager) {
            ScalingLayoutManager scalingLayoutManager = (ScalingLayoutManager)layoutManager;
            d = scalingLayoutManager.scaleComponents(this);
        } else {
            super.doLayout();
            d = 1.0;
        }
        this.setScale(d);
    }

    private void doSetLayout(LayoutManager layoutManager, boolean bl) {
        LayoutManager layoutManager2 = this.getLayout();
        if (layoutManager.equals(layoutManager2)) {
            return;
        }
        super.setLayout(layoutManager);
        if (bl) {
            this.resetZoomLayouts(layoutManager);
        }
        this.firePropertyChange(LAYOUT_PROPERTY, layoutManager2, layoutManager);
    }

    public void ensurePageIsVisible(int n) throws IllegalArgumentException {
        Component component = this.getPageComponent(n);
        Rectangle rectangle = component.getBounds();
        this.scrollRectToVisible(rectangle);
    }

    private Point findNearestComponentPoint(Point point) {
        double d = Double.MAX_VALUE;
        Point point2 = null;
        Component component = this.findComponentAt(point);
        if (component != null && component != this) {
            return point;
        }
        double d2 = point.getX();
        double d3 = point.getY();
        Pageable pageable = this.getPageable();
        int n = pageable.getNumberOfPages();
        int n2 = 0;
        while (n2 < n) {
            double d4;
            double d5;
            double d6;
            double d7;
            Component component2 = this.getPageComponent(n2);
            double d8 = component2.getX();
            double d9 = component2.getY();
            double d10 = component2.getWidth();
            double d11 = component2.getHeight();
            double d12 = Math.abs(d2 - d8);
            double d13 = Math.min(d12, d7 = Math.abs(d2 - d8 + d10));
            double d14 = d13 * d13 + (d6 = Math.min(d5 = Math.abs(d3 - d9), d4 = Math.abs(d3 - d9 + d11))) * d6;
            double d15 = Math.sqrt(d14);
            if (d15 < d) {
                d = d15;
                if (point2 == null) {
                    point2 = new Point();
                }
                double d16 = d2 >= d8 && d2 < d8 + d10 ? d2 : (d2 < d8 ? d8 : d8 + d10 - 1.0);
                double d17 = d3 >= d9 && d3 < d9 + d11 ? d3 : (d3 < d9 ? d9 : d9 + d11 - 1.0);
                point2.setLocation(d16, d17);
            }
            ++n2;
        }
        return point2;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJPrintPreviewPane();
        }
        return this.accessibleContext;
    }

    public boolean getMarginsAreShown() {
        return this.marginsAreShown;
    }

    public int getMode() {
        return this.mode;
    }

    public Component getPageComponent(int n) throws IndexOutOfBoundsException {
        return this.getComponent(n);
    }

    public int getPageIndexAt(Point point) throws NullPointerException {
        int n = (int)point.getX();
        int n2 = (int)point.getY();
        return this.getPageIndexAt(n, n2);
    }

    public int getPageIndexAt(int n, int n2) {
        Component component = this.getComponentAt(n, n2);
        if (component == null || component == this) {
            return -1;
        }
        return this.getPageIndexOf(component);
    }

    private int getPageIndexOf(Component component) {
        if (component instanceof JPrintPreviewPage) {
            JPrintPreviewPage jPrintPreviewPage = (JPrintPreviewPage)component;
            int n = jPrintPreviewPage.getPageIndex();
            return n;
        }
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] == component) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Pageable getPageable() {
        return this.pageable;
    }

    public PageNumberRenderer getPageNumberRenderer() {
        return this.pageNumberRenderer;
    }

    public boolean getPageNumbersAreShown() {
        return this.pageNumbersAreShown;
    }

    public boolean getPageSelectionAllowed() {
        return this.pageSelectionAllowed;
    }

    public ListSelectionModel getPageSelectionModel() {
        return this.selectionModel;
    }

    public Dimension getPreferredScrollableViewportSize() {
        LayoutManager layoutManager = this.getLayout();
        if (layoutManager instanceof ScrollableLayoutManager) {
            ScrollableLayoutManager scrollableLayoutManager = (ScrollableLayoutManager)layoutManager;
            return scrollableLayoutManager.getPreferredScrollableViewportSize(this);
        }
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.getLayout().preferredLayoutSize(this);
        return dimension;
    }

    public double getScale() {
        return this.scale;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        LayoutManager layoutManager = this.getLayout();
        if (layoutManager instanceof ScrollableLayoutManager) {
            ScrollableLayoutManager scrollableLayoutManager = (ScrollableLayoutManager)layoutManager;
            return scrollableLayoutManager.getScrollableBlockIncrement(this, rectangle, n, n2);
        }
        return this.getHeight();
    }

    public boolean getScrollableTracksViewportHeight() {
        LayoutManager layoutManager = this.getLayout();
        if (layoutManager instanceof ScrollableLayoutManager) {
            ScrollableLayoutManager scrollableLayoutManager = (ScrollableLayoutManager)layoutManager;
            return scrollableLayoutManager.getScrollableTracksViewportHeight(this);
        }
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        LayoutManager layoutManager = this.getLayout();
        if (layoutManager instanceof ScrollableLayoutManager) {
            ScrollableLayoutManager scrollableLayoutManager = (ScrollableLayoutManager)layoutManager;
            return scrollableLayoutManager.getScrollableTracksViewportWidth(this);
        }
        return false;
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        LayoutManager layoutManager = this.getLayout();
        if (layoutManager instanceof ScrollableLayoutManager) {
            ScrollableLayoutManager scrollableLayoutManager = (ScrollableLayoutManager)layoutManager;
            return scrollableLayoutManager.getScrollableUnitIncrement(this, rectangle, n, n2);
        }
        return 10;
    }

    public int getSelectedPageIndex() {
        if (!this.getPageSelectionAllowed()) {
            return -1;
        }
        ListSelectionModel listSelectionModel = this.getPageSelectionModel();
        return listSelectionModel.getMinSelectionIndex();
    }

    public Color getSelectionBackground() {
        return this.selectionBackground;
    }

    public Color getSelectionForeground() {
        return this.selectionForeground;
    }

    private LayoutManager getZoomInLayout() {
        LayoutManager layoutManager;
        if (this.zoomStack.size() > this.zoomIndex + 1) {
            layoutManager = (LayoutManager)this.zoomStack.get(this.zoomIndex + 1);
        } else {
            double d = this.getScale();
            ZoomFunction zoomFunction = this.getZoomFunction();
            double d2 = zoomFunction.zoomIn(d);
            if (d2 == d) {
                return this.getLayout();
            }
            layoutManager = this.createZoomLayout(d2);
            this.zoomStack.addLast(layoutManager);
        }
        ++this.zoomIndex;
        return layoutManager;
    }

    private LayoutManager getZoomOutLayout() {
        LayoutManager layoutManager;
        if (this.zoomIndex > 0) {
            --this.zoomIndex;
            layoutManager = (LayoutManager)this.zoomStack.get(this.zoomIndex);
        } else {
            double d = this.getScale();
            ZoomFunction zoomFunction = this.getZoomFunction();
            double d2 = zoomFunction.zoomOut(d);
            if (d2 == d) {
                return this.getLayout();
            }
            layoutManager = this.createZoomLayout(d2);
            this.zoomStack.addFirst(layoutManager);
        }
        return layoutManager;
    }

    public PrintPreviewPaneUI getUI() {
        return (PrintPreviewPaneUI)this.ui;
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public ZoomFunction getZoomFunction() {
        return this.zoomFunction;
    }

    private void installChildren() {
        int n = this.pageable.getNumberOfPages();
        int n2 = 0;
        while (n2 < n) {
            Printable printable = this.pageable.getPrintable(n2);
            PageFormat pageFormat = this.pageable.getPageFormat(n2);
            Component component = this.createPageComponent(printable, pageFormat, n2);
            this.add(component);
            ++n2;
        }
    }

    public boolean isPageSelected(int n) {
        if (!this.getPageSelectionAllowed()) {
            return false;
        }
        ListSelectionModel listSelectionModel = this.getPageSelectionModel();
        return listSelectionModel.isSelectedIndex(n);
    }

    public PageFormat pageSetup(int n) throws IllegalArgumentException {
        Pageable pageable = this.getPageable();
        if (n < -1 || n >= pageable.getNumberOfPages()) {
            throw new IllegalArgumentException("pageIndex out of range");
        }
        PageFormat pageFormat = n == -1 ? new PageFormat() : pageable.getPageFormat(n);
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPageable(pageable);
        PageFormat pageFormat2 = printerJob.pageDialog(pageFormat);
        if (pageFormat2 == pageFormat) {
            return null;
        }
        return pageFormat2;
    }

    public boolean print() throws PrinterException {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        Pageable pageable = this.getPageable();
        printerJob.setPageable(pageable);
        if (!printerJob.printDialog()) {
            return false;
        }
        printerJob.print();
        return true;
    }

    public void printAll() throws PrinterException {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        Pageable pageable = this.getPageable();
        printerJob.setPageable(pageable);
        printerJob.print();
    }

    private void resetZoomLayouts(LayoutManager layoutManager) {
        this.zoomStack.clear();
        this.zoomStack.addLast(layoutManager);
        this.zoomIndex = 0;
    }

    public void setLayout(LayoutManager layoutManager) {
        if (layoutManager == this.getLayout()) {
            return;
        }
        Rectangle rectangle = this.getVisibleRect();
        if (rectangle.getX() == 0.0 && rectangle.getY() == 0.0) {
            this.doSetLayout(layoutManager, true);
            return;
        }
        Point point = this.calculateCenter();
        Point point2 = this.findNearestComponentPoint(point);
        if (point2 == null) {
            this.doSetLayout(layoutManager, true);
            return;
        }
        Component component = this.findComponentAt(point2);
        if (component == null || component == this) {
            this.doSetLayout(layoutManager, true);
            return;
        }
        double d = point.getX();
        double d2 = point.getY();
        Rectangle rectangle2 = component.getBounds();
        double d3 = rectangle2.getWidth();
        double d4 = rectangle2.getHeight();
        double d5 = rectangle2.getX();
        double d6 = rectangle2.getY();
        this.doSetLayout(layoutManager, true);
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getPreferredSize();
        this.setSize(dimension2);
        this.doLayout();
        Rectangle rectangle3 = component.getBounds();
        double d7 = rectangle3.getWidth();
        double d8 = rectangle3.getHeight();
        double d9 = rectangle3.getX();
        double d10 = rectangle3.getY();
        double d11 = (d7 * (d - d5) + d3 * d9) / d3;
        double d12 = (d8 * (d2 - d6) + d4 * d10) / d4;
        double d13 = rectangle.getWidth();
        double d14 = rectangle.getHeight();
        double d15 = d11 - d13 / 2.0;
        double d16 = d12 - d14 / 2.0;
        if (rectangle.getY() + rectangle.getHeight() > dimension2.getHeight()) {
            d16 = d16 + rectangle.getY() + rectangle.getHeight() - dimension2.getHeight();
        }
        if (rectangle.getX() + rectangle.getWidth() > dimension2.getWidth()) {
            d15 = d15 + rectangle.getX() + rectangle.getWidth() - dimension2.getWidth();
        }
        Rectangle rectangle4 = new Rectangle((int)d15, (int)d16, (int)d13, (int)d14);
        this.scrollRectToVisible(rectangle4);
    }

    public void setMarginsAreShown(boolean bl) {
        boolean bl2 = this.marginsAreShown;
        this.marginsAreShown = bl;
        this.firePropertyChange(MARGINS_ARE_SHOWN_PROPERTY, bl2, bl);
    }

    public void setMode(int n) throws IllegalArgumentException {
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException("illegal print preview mode");
        }
        int n2 = this.mode;
        this.mode = n;
        this.firePropertyChange(MODE_PROPERTY, n2, n);
    }

    public void setPageable(Pageable pageable) throws NullPointerException {
        Utility.checkNull(pageable, PAGEABLE_PROPERTY);
        Pageable pageable2 = this.pageable;
        this.pageable = pageable;
        this.uninstallChildren();
        this.installChildren();
        this.firePropertyChange(PAGEABLE_PROPERTY, pageable2, pageable);
    }

    public void setPageNumberRenderer(PageNumberRenderer pageNumberRenderer) {
        PageNumberRenderer pageNumberRenderer2 = this.pageNumberRenderer;
        this.pageNumberRenderer = pageNumberRenderer;
        this.firePropertyChange(PAGE_NUMBER_RENDERER_PROPERTY, pageNumberRenderer2, pageNumberRenderer);
    }

    public void setPageNumbersAreShown(boolean bl) {
        boolean bl2 = this.pageNumbersAreShown;
        this.pageNumbersAreShown = bl;
        this.firePropertyChange(PAGE_NUMBERS_ARE_SHOWN_PROPERTY, bl2, bl);
    }

    public void setPageSelectionAllowed(boolean bl) {
        boolean bl2 = this.pageSelectionAllowed;
        this.pageSelectionAllowed = bl;
        this.firePropertyChange(PAGE_SELECTION_ALLOWED_PROPERTY, bl2, bl);
    }

    public void setPageSelectionModel(ListSelectionModel listSelectionModel) {
        Utility.checkNull(listSelectionModel, SELECTION_MODEL_PROPERTY);
        ListSelectionModel listSelectionModel2 = this.selectionModel;
        this.selectionModel = listSelectionModel;
        this.firePropertyChange(SELECTION_MODEL_PROPERTY, listSelectionModel2, listSelectionModel);
    }

    private void setScale(double d) {
        double d2 = this.scale;
        this.scale = d;
        this.firePropertyChange(SCALE_PROPERTY, d2, d);
    }

    public void setSelectionBackground(Color color) {
        Color color2 = this.selectionBackground;
        this.selectionBackground = color;
        this.firePropertyChange(SELECTION_BACKGROUND_PROPERTY, color2, color);
    }

    public void setSelectionForeground(Color color) {
        Color color2 = this.selectionForeground;
        this.selectionForeground = color;
        this.firePropertyChange(SELECTION_FOREGROUND_PROPERTY, color2, color);
    }

    public void setZoomFunction(ZoomFunction zoomFunction) throws NullPointerException {
        Utility.checkNull(zoomFunction, "zoomFunction");
        ZoomFunction zoomFunction2 = this.zoomFunction;
        this.zoomFunction = zoomFunction;
        this.resetZoomLayouts(this.getLayout());
        this.firePropertyChange(ZOOM_FUNCTION_PROPERTY, zoomFunction2, zoomFunction);
    }

    public void setUI(PrintPreviewPaneUI printPreviewPaneUI) {
        super.setUI(printPreviewPaneUI);
    }

    private void uninstallChildren() {
        this.removeAll();
    }

    public void updateUI() {
        this.setUI((PrintPreviewPaneUI)UIManager.getUI(this));
        int n = this.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            Component component = this.getComponent(n2);
            if (component instanceof JComponent) {
                ((JComponent)component).updateUI();
            }
            ++n2;
        }
    }

    public boolean zoom(double d) throws IllegalArgumentException {
        Point point = this.calculateCenter();
        Point point2 = this.findNearestComponentPoint(point);
        if (point2 == null) {
            return false;
        }
        return this.zoom(d, point2);
    }

    public boolean zoom(double d, Point point) throws IllegalArgumentException, NullPointerException {
        if (d <= 0.0) {
            throw new IllegalArgumentException("scale must be positive");
        }
        Component component = this.findComponentAt(point);
        if (component == null || component == this) {
            return false;
        }
        LayoutManager layoutManager = this.createZoomLayout(d);
        return this.zoom(layoutManager, point, component, true);
    }

    private boolean zoom(LayoutManager layoutManager, Point point, Component component, boolean bl) {
        Rectangle rectangle = this.getVisibleRect();
        double d = point.getX();
        double d2 = point.getY();
        Rectangle rectangle2 = component.getBounds();
        double d3 = rectangle2.getWidth();
        double d4 = rectangle2.getHeight();
        double d5 = rectangle2.getX();
        double d6 = rectangle2.getY();
        this.doSetLayout(layoutManager, bl);
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getPreferredSize();
        this.setSize(dimension2);
        this.doLayout();
        Rectangle rectangle3 = component.getBounds();
        double d7 = rectangle3.getWidth();
        double d8 = rectangle3.getHeight();
        double d9 = rectangle3.getX();
        double d10 = rectangle3.getY();
        double d11 = (d7 * (d - d5) + d3 * d9) / d3;
        double d12 = (d8 * (d2 - d6) + d4 * d10) / d4;
        double d13 = rectangle.getWidth();
        double d14 = rectangle.getHeight();
        double d15 = d11 - d13 / 2.0;
        double d16 = d12 - d14 / 2.0;
        if (rectangle.getY() + rectangle.getHeight() > dimension2.getHeight()) {
            d16 = d16 + rectangle.getY() + rectangle.getHeight() - dimension2.getHeight();
        }
        if (rectangle.getX() + rectangle.getWidth() > dimension2.getWidth()) {
            d15 = d15 + rectangle.getX() + rectangle.getWidth() - dimension2.getWidth();
        }
        Rectangle rectangle4 = new Rectangle((int)d15, (int)d16, (int)d13, (int)d14);
        this.scrollRectToVisible(rectangle4);
        return true;
    }

    public boolean zoomIn() {
        Point point = this.calculateCenter();
        Point point2 = this.findNearestComponentPoint(point);
        if (point2 == null) {
            return false;
        }
        return this.zoomIn(point2);
    }

    public void zoomIn(int n) throws IllegalArgumentException {
        Component component = this.getPageComponent(n);
        Rectangle rectangle = component.getBounds();
        int n2 = (int)rectangle.getCenterX();
        int n3 = (int)rectangle.getCenterY();
        Point point = new Point(n2, n3);
        this.zoomIn(point);
    }

    public boolean zoomIn(Point point) throws NullPointerException {
        Component component = this.findComponentAt(point);
        if (component == null || component == this) {
            return false;
        }
        LayoutManager layoutManager = this.getZoomInLayout();
        return this.zoom(layoutManager, point, component, false);
    }

    public boolean zoomOut() {
        Point point = this.calculateCenter();
        Point point2 = this.findNearestComponentPoint(point);
        if (point2 == null) {
            return false;
        }
        return this.zoomOut(point2);
    }

    public void zoomOut(int n) throws IllegalArgumentException {
        Component component = this.getPageComponent(n);
        Rectangle rectangle = component.getBounds();
        int n2 = (int)rectangle.getCenterX();
        int n3 = (int)rectangle.getCenterY();
        Point point = new Point(n2, n3);
        this.zoomOut(point);
    }

    public boolean zoomOut(Point point) throws NullPointerException {
        Component component = this.findComponentAt(point);
        if (component == null || component == this) {
            return false;
        }
        LayoutManager layoutManager = this.getZoomOutLayout();
        return this.zoom(layoutManager, point, component, false);
    }

    static {
        Utility.checkDeployment();
        Utility.initDefault(uiClassID, "sos.preview.BasicPrintPreviewPaneUI");
    }

    protected class AccessibleJPrintPreviewPane
    extends JComponent.AccessibleJComponent
    implements AccessibleAction,
    AccessibleSelection {
        protected AccessibleJPrintPreviewPane() {
            super(JPrintPreviewPane.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessiblePrintPreviewRole.PRINT_PREVIEW_PANE;
        }

        public void addAccessibleSelection(int n) {
            Accessible accessible = this.getAccessibleChild(n);
            if (!JPrintPreviewPane.this.getPageSelectionAllowed()) {
                return;
            }
            ListSelectionModel listSelectionModel = JPrintPreviewPane.this.getPageSelectionModel();
            int n2 = n;
            if (accessible instanceof Component) {
                n2 = JPrintPreviewPane.this.getPageIndexOf((Component)((Object)accessible));
            }
            listSelectionModel.addSelectionInterval(n2, n2);
        }

        public void clearAccessibleSelection() {
            if (!JPrintPreviewPane.this.getPageSelectionAllowed()) {
                return;
            }
            ListSelectionModel listSelectionModel = JPrintPreviewPane.this.getPageSelectionModel();
            listSelectionModel.clearSelection();
        }

        public boolean doAccessibleAction(int n) {
            if (n == 0) {
                JPrintPreviewPane.this.zoomIn();
                return true;
            }
            if (n == 1) {
                JPrintPreviewPane.this.zoomOut();
                return true;
            }
            return false;
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public int getAccessibleActionCount() {
            return 2;
        }

        public String getAccessibleActionDescription(int n) {
            if (n == 0) {
                return UIManager.getString("zoom_in");
            }
            if (n == 1) {
                return UIManager.getString("zoom_out");
            }
            return null;
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public Accessible getAccessibleSelection(int n) {
            int[] nArray = this.getSelectedIndices();
            return this.getAccessibleChild(nArray[n]);
        }

        public int getAccessibleSelectionCount() {
            int[] nArray = this.getSelectedIndices();
            return nArray.length;
        }

        private int[] getSelectedIndices() {
            if (!JPrintPreviewPane.this.getPageSelectionAllowed()) {
                return new int[0];
            }
            ListSelectionModel listSelectionModel = JPrintPreviewPane.this.getPageSelectionModel();
            if (listSelectionModel.isSelectionEmpty()) {
                return new int[0];
            }
            int n = listSelectionModel.getMinSelectionIndex();
            int n2 = listSelectionModel.getMaxSelectionIndex();
            int n3 = n2 - n + 1;
            int[] nArray = new int[n3];
            int n4 = 0;
            int n5 = n;
            while (n5 <= n2) {
                if (listSelectionModel.isSelectedIndex(n5)) {
                    nArray[n4++] = n5;
                }
                ++n5;
            }
            int[] nArray2 = new int[n4];
            System.arraycopy(nArray, 0, nArray2, 0, n4);
            return nArray2;
        }

        public boolean isAccessibleChildSelected(int n) {
            Accessible accessible = this.getAccessibleChild(n);
            if (!JPrintPreviewPane.this.getPageSelectionAllowed()) {
                return false;
            }
            ListSelectionModel listSelectionModel = JPrintPreviewPane.this.getPageSelectionModel();
            int n2 = n;
            if (accessible instanceof Component) {
                n2 = JPrintPreviewPane.this.getPageIndexOf((Component)((Object)accessible));
            }
            return listSelectionModel.isSelectedIndex(n2);
        }

        public void removeAccessibleSelection(int n) {
            Accessible accessible = this.getAccessibleChild(n);
            if (!JPrintPreviewPane.this.getPageSelectionAllowed()) {
                return;
            }
            ListSelectionModel listSelectionModel = JPrintPreviewPane.this.getPageSelectionModel();
            int n2 = n;
            if (accessible instanceof Component) {
                n2 = JPrintPreviewPane.this.getPageIndexOf((Component)((Object)accessible));
            }
            listSelectionModel.removeSelectionInterval(n2, n2);
        }

        public void selectAllAccessibleSelection() {
            if (!JPrintPreviewPane.this.getPageSelectionAllowed()) {
                return;
            }
            ListSelectionModel listSelectionModel = JPrintPreviewPane.this.getPageSelectionModel();
            Pageable pageable = JPrintPreviewPane.this.getPageable();
            int n = pageable.getNumberOfPages();
            int n2 = 0;
            while (n2 < n) {
                Component component = JPrintPreviewPane.this.getPageComponent(n2);
                if (component instanceof Accessible) {
                    listSelectionModel.addSelectionInterval(n2, n2);
                }
                ++n2;
            }
        }
    }
}

