/*
 * Decompiled with CFR 0.152.
 */
package sos.preview;

import java.awt.Dimension;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.JComponent;
import javax.swing.UIManager;
import sos.preview.AccessiblePrintPreviewRole;
import sos.preview.JPrintPreviewPane;
import sos.preview.PrintPreviewPageUI;
import sos.preview.Scaleable;
import sos.preview.Utility;

public class JPrintPreviewPage
extends JComponent
implements Accessible,
Scaleable {
    private static final String uiClassID = "PrintPreviewPageUI";
    private Printable printable;
    private PageFormat pageFormat;
    private int pageIndex;
    private JPrintPreviewPane printPreviewPane;

    public JPrintPreviewPage(JPrintPreviewPane jPrintPreviewPane, Printable printable, PageFormat pageFormat, int n) throws NullPointerException, IllegalArgumentException {
        Utility.initDefault(uiClassID, "sos.preview.BasicPrintPreviewPageUI");
        Utility.checkNull(jPrintPreviewPane, "printPreviewPane");
        Utility.checkNull(printable, "printable");
        Utility.checkNull(pageFormat, "pageFormat");
        if (n < 0) {
            throw new IllegalArgumentException("pageIndex cannot be negative");
        }
        this.printPreviewPane = jPrintPreviewPane;
        this.printable = printable;
        this.pageFormat = pageFormat;
        this.pageIndex = n;
        this.updateUI();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJPrintPreviewPage();
        }
        return this.accessibleContext;
    }

    public double getFixedHeight() {
        PrintPreviewPageUI printPreviewPageUI = (PrintPreviewPageUI)this.ui;
        return printPreviewPageUI.getFixedHeight(this);
    }

    public double getFixedWidth() {
        PrintPreviewPageUI printPreviewPageUI = (PrintPreviewPageUI)this.ui;
        return printPreviewPageUI.getFixedWidth(this);
    }

    public JPrintPreviewPane getJPrintPreviewPane() {
        return this.printPreviewPane;
    }

    public PageFormat getPageFormat() {
        return this.pageFormat;
    }

    public Printable getPrintable() {
        return this.printable;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public Dimension getScaleablePreferredSize() {
        PrintPreviewPageUI printPreviewPageUI = (PrintPreviewPageUI)this.ui;
        return printPreviewPageUI.getScaleablePreferredSize(this);
    }

    public PrintPreviewPageUI getUI() {
        return (PrintPreviewPageUI)this.ui;
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void setUI(PrintPreviewPageUI printPreviewPageUI) {
        super.setUI(printPreviewPageUI);
    }

    public void updateUI() {
        this.setUI((PrintPreviewPageUI)UIManager.getUI(this));
    }

    protected class AccessibleJPrintPreviewPage
    extends JComponent.AccessibleJComponent {
        protected AccessibleJPrintPreviewPage() {
            super(JPrintPreviewPage.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessiblePrintPreviewRole.PRINT_PREVIEW_PAGE;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            accessibleStateSet.add(AccessibleState.SELECTABLE);
            if (JPrintPreviewPage.this.printPreviewPane.isPageSelected(JPrintPreviewPage.this.pageIndex)) {
                accessibleStateSet.add(AccessibleState.SELECTED);
            }
            return accessibleStateSet;
        }
    }
}

