/*
 * Decompiled with CFR 0.152.
 */
package sos.preview;

import java.awt.ComponentOrientation;
import java.text.Collator;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Locale;
import javax.swing.UIManager;
import sos.preview.BasicPrintPreviewPaneUI;
import sos.preview.FitLayout;

public class FitLayoutFormat
extends Format {
    private Collator collator;
    private Locale locale;

    public FitLayoutFormat() {
        this(Locale.getDefault());
    }

    public FitLayoutFormat(Locale locale) {
        this.locale = locale;
        this.collator = Collator.getInstance(locale);
        this.collator.setStrength(1);
    }

    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (!(object instanceof FitLayout)) {
            throw new IllegalArgumentException("Cannot format object.");
        }
        FitLayout fitLayout = (FitLayout)object;
        int n = fitLayout.getAxis();
        ComponentOrientation componentOrientation = ComponentOrientation.getOrientation(this.locale);
        boolean bl = n == 0 || n == 3 && !componentOrientation.isHorizontal() || n == 2 && componentOrientation.isHorizontal();
        String string = bl ? UIManager.getString("JPrintPreviewPane.fitWidthLayoutName") : UIManager.getString("JPrintPreviewPane.fitHeightLayoutName");
        stringBuffer.append(string);
        return stringBuffer;
    }

    public static Locale[] getAvailableLocales() {
        return new Locale[]{Locale.US};
    }

    public static FitLayoutFormat getInstance() {
        return new FitLayoutFormat();
    }

    public static FitLayoutFormat getInstance(Locale locale) {
        return new FitLayoutFormat(locale);
    }

    public Object parseObject(String string, ParsePosition parsePosition) {
        String string2 = UIManager.getString("JPrintPreviewPane.fitWidthLayoutName");
        String string3 = UIManager.getString("JPrintPreviewPane.fitHeightLayoutName");
        if (string2 != null && this.collator.compare(string2, string) == 0) {
            parsePosition.setIndex(string.length());
            return this.createLayout(0);
        }
        if (string3 != null && this.collator.compare(string3, string) == 0) {
            parsePosition.setIndex(string.length());
            return this.createLayout(1);
        }
        return null;
    }

    private FitLayout createLayout(int n) {
        int n2 = UIManager.getInt(BasicPrintPreviewPaneUI.HORIZONTAL_ALIGNMENT);
        int n3 = UIManager.getInt(BasicPrintPreviewPaneUI.VERTICAL_ALIGNMENT);
        int n4 = UIManager.getInt(BasicPrintPreviewPaneUI.HORIZONTAL_SPACING);
        int n5 = UIManager.getInt(BasicPrintPreviewPaneUI.VERTICAL_SPACING);
        int n6 = UIManager.getInt(BasicPrintPreviewPaneUI.LEFT_MARGIN);
        int n7 = UIManager.getInt(BasicPrintPreviewPaneUI.RIGHT_MARGIN);
        int n8 = UIManager.getInt(BasicPrintPreviewPaneUI.TOP_MARGIN);
        int n9 = UIManager.getInt(BasicPrintPreviewPaneUI.BOTTOM_MARGIN);
        ComponentOrientation componentOrientation = ComponentOrientation.getOrientation(this.locale);
        int n10 = componentOrientation.isHorizontal() ? n5 : n4;
        return new FitLayout(n, n2, n3, n10, n6, n7, n8, n9);
    }
}

