/*
 * Decompiled with CFR 0.152.
 */
package sos.preview;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.Serializable;
import sos.preview.LayoutSupport;
import sos.preview.ScalingLayoutManager;
import sos.preview.ScrollableLayoutManager;
import sos.preview.Utility;

public class FitLayout
implements ScrollableLayoutManager,
ScalingLayoutManager,
Serializable {
    private static final int DEFAULT_SPACING = 10;
    private static final int DEFAULT_LEFT_MARGIN = 10;
    private static final int DEFAULT_RIGHT_MARGIN = 10;
    private static final int DEFAULT_TOP_MARGIN = 10;
    private static final int DEFAULT_BOTTOM_MARGIN = 10;
    private static final int DEFAULT_HORIZONTAL_ALIGNMENT = 0;
    private static final int DEFAULT_VERTICAL_ALIGNMENT = 0;
    private int axis;
    private int spacing;
    private int leftMargin;
    private int rightMargin;
    private int topMargin;
    private int bottomMargin;
    private int horizontalAlignment;
    private int verticalAlignment;

    public FitLayout(int n) throws IllegalArgumentException {
        this(n, 0, 0, 10, 10, 10, 10, 10);
    }

    public FitLayout(int n, int n2, int n3) throws IllegalArgumentException {
        this(n, n2, n3, 10, 10, 10, 10, 10);
    }

    public FitLayout(int n, int n2, int n3, int n4, int n5, int n6) throws IllegalArgumentException {
        this(n, 0, 0, n2, n3, n4, n5, n6);
    }

    public FitLayout(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) throws IllegalArgumentException {
        if (n != 0 && n != 1 && n != 3 && n != 2) {
            throw new IllegalArgumentException("Invalid axis");
        }
        Utility.checkHorizontalAlignment(n2);
        Utility.checkVerticalAlignment(n3);
        Utility.checkSpacing(n4, n4);
        Utility.checkMargins(n5, n6, n7, n8);
        this.axis = n;
        this.horizontalAlignment = n2;
        this.verticalAlignment = n3;
        this.spacing = n4;
        this.leftMargin = n5;
        this.rightMargin = n6;
        this.topMargin = n7;
        this.bottomMargin = n8;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    private double doScaleComponents(Container container, boolean bl) {
        Dimension dimension = container.getSize();
        int n = container.getComponentCount();
        LayoutSupport layoutSupport = LayoutSupport.getSupport(container);
        double d = layoutSupport.getMaximumFixedWidth();
        double d2 = layoutSupport.getMaximumFixedHeight();
        double d3 = layoutSupport.getMaximumPreferredScaleableWidth();
        double d4 = layoutSupport.getMaximumPreferredScaleableHeight();
        if (this.isHorizontal(container)) {
            double d5 = d + d3;
            int n2 = (int)dimension.getWidth();
            double d6 = n2 - this.leftMargin - this.rightMargin;
            double d7 = d6 / d5;
            if (bl) {
                int n3 = (int)d6;
                int n4 = (int)(d2 + d4 * d7);
                layoutSupport.layoutComponents(n, 1, n3, n4, d7, 0, this.spacing, this.leftMargin, this.rightMargin, this.topMargin, this.bottomMargin, this.horizontalAlignment, this.verticalAlignment);
            }
            return d7;
        }
        double d8 = d2 + d4;
        int n5 = (int)dimension.getHeight();
        double d9 = n5 - this.topMargin - this.bottomMargin;
        double d10 = d9 / d8;
        if (bl) {
            int n6 = (int)(d + d3 * d10);
            int n7 = (int)d9;
            layoutSupport.layoutComponents(1, n, n6, n7, d10, this.spacing, 0, this.leftMargin, this.rightMargin, this.topMargin, this.bottomMargin, this.horizontalAlignment, this.verticalAlignment);
        }
        return d10;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FitLayout)) {
            return false;
        }
        FitLayout fitLayout = (FitLayout)object;
        return this.getAxis() == fitLayout.getAxis() && this.leftMargin == fitLayout.leftMargin && this.rightMargin == fitLayout.rightMargin && this.topMargin == fitLayout.topMargin && this.bottomMargin == fitLayout.bottomMargin && this.spacing == fitLayout.spacing && this.horizontalAlignment == fitLayout.horizontalAlignment && this.verticalAlignment == fitLayout.verticalAlignment;
    }

    public int getAxis() {
        return this.axis;
    }

    public Dimension getPreferredScrollableViewportSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public int hashCode() {
        return this.getAxis() * 31 + Utility.computeHashCode(this.horizontalAlignment, this.verticalAlignment, this.spacing, this.spacing, this.leftMargin, this.rightMargin, this.topMargin, this.bottomMargin);
    }

    public double preferredScale(Container container) {
        double d;
        Container container2 = container.getParent();
        if (container2 == null) {
            return 0.0;
        }
        Dimension dimension = container2.getSize();
        int n = (int)dimension.getWidth();
        int n2 = (int)dimension.getHeight();
        if (n == 0 || n2 == 0) {
            return 1.0;
        }
        int n3 = container.getComponentCount();
        LayoutSupport layoutSupport = LayoutSupport.getSupport(container);
        double d2 = layoutSupport.getMaximumFixedWidth();
        double d3 = layoutSupport.getMaximumFixedHeight();
        double d4 = layoutSupport.getMaximumPreferredScaleableWidth();
        double d5 = layoutSupport.getMaximumPreferredScaleableHeight();
        if (this.isHorizontal(container)) {
            double d6 = d2 + d4;
            double d7 = n - this.leftMargin - this.rightMargin;
            d = d7 / d6;
        } else {
            double d8 = d3 + d5;
            double d9 = n2 - this.topMargin - this.bottomMargin;
            d = d9 / d8;
        }
        return d;
    }

    public int getScrollableBlockIncrement(Container container, Rectangle rectangle, int n, int n2) {
        return n == 0 ? rectangle.width : rectangle.height;
    }

    public boolean getScrollableTracksViewportHeight(Container container) {
        return !this.isHorizontal(container);
    }

    public boolean getScrollableTracksViewportWidth(Container container) {
        return this.isHorizontal(container);
    }

    public int getScrollableUnitIncrement(Container container, Rectangle rectangle, int n, int n2) {
        return 20;
    }

    private Dimension idealPreferredLayoutSize(Container container) {
        int n = container.getComponentCount();
        LayoutSupport layoutSupport = LayoutSupport.getSupport(container);
        if (this.isHorizontal(container)) {
            return layoutSupport.getDimensions(1.0, n, 1, 0, this.spacing, this.leftMargin, this.rightMargin, this.topMargin, this.bottomMargin);
        }
        return layoutSupport.getDimensions(1.0, 1, n, this.spacing, 0, this.leftMargin, this.rightMargin, this.topMargin, this.bottomMargin);
    }

    private boolean isHorizontal(Container container) {
        ComponentOrientation componentOrientation = container.getComponentOrientation();
        boolean bl = this.axis == 0 || this.axis == 3 && !componentOrientation.isHorizontal() || this.axis == 2 && componentOrientation.isHorizontal();
        return bl;
    }

    public void layoutContainer(Container container) {
        this.scaleComponents(container);
    }

    public Dimension minimumLayoutSize(Container container) {
        int n = container.getComponentCount();
        LayoutSupport layoutSupport = LayoutSupport.getSupport(container);
        if (this.isHorizontal(container)) {
            return layoutSupport.getDimensions(0.05, n, 1, 0, this.spacing, this.leftMargin, this.rightMargin, this.topMargin, this.bottomMargin);
        }
        return layoutSupport.getDimensions(0.05, 1, n, this.spacing, 0, this.leftMargin, this.rightMargin, this.topMargin, this.bottomMargin);
    }

    public Dimension preferredLayoutSize(Container container) {
        Container container2 = container.getParent();
        if (container2 == null) {
            return new Dimension(0, 0);
        }
        Dimension dimension = container2.getSize();
        int n = (int)dimension.getWidth();
        int n2 = (int)dimension.getHeight();
        if (n == 0 || n2 == 0) {
            return this.idealPreferredLayoutSize(container);
        }
        int n3 = container.getComponentCount();
        LayoutSupport layoutSupport = LayoutSupport.getSupport(container);
        double d = layoutSupport.getMaximumFixedWidth();
        double d2 = layoutSupport.getMaximumFixedHeight();
        double d3 = layoutSupport.getMaximumPreferredScaleableWidth();
        double d4 = layoutSupport.getMaximumPreferredScaleableHeight();
        if (this.isHorizontal(container)) {
            double d5 = d + d3;
            double d6 = n - this.leftMargin - this.rightMargin;
            double d7 = d6 / d5;
            int n4 = (int)(d2 + d4 * d7);
            int n5 = this.topMargin + this.bottomMargin + n3 * n4 + (n3 - 1) * this.spacing;
            n5 = Math.max(n5, n2);
            return new Dimension(n, n5);
        }
        double d8 = d2 + d4;
        double d9 = n2 - this.topMargin - this.bottomMargin;
        double d10 = d9 / d8;
        int n6 = (int)(d + d3 * d10);
        int n7 = this.leftMargin + this.rightMargin + n3 * n6 + (n3 - 1) * this.spacing;
        n7 = Math.max(n7, n);
        return new Dimension(n7, n2);
    }

    public void removeLayoutComponent(Component component) {
    }

    public double scaleComponents(Container container) {
        return this.doScaleComponents(container, true);
    }
}

