/*
 * Decompiled with CFR 0.152.
 */
package sos.preview;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;
import sos.preview.LayoutSupport;
import sos.preview.ScalingLayoutManager;
import sos.preview.ScrollableLayoutManager;
import sos.preview.Utility;

public class FitAllLayout
implements ScrollableLayoutManager,
ScalingLayoutManager,
Serializable {
    private static final int DEFAULT_HORIZONTAL_SPACING = 10;
    private static final int DEFAULT_VERTICAL_SPACING = 10;
    private static final int DEFAULT_MINIMUM_LEFT_MARGIN = 10;
    private static final int DEFAULT_MINIMUM_RIGHT_MARGIN = 10;
    private static final int DEFAULT_MINIMUM_TOP_MARGIN = 10;
    private static final int DEFAULT_MINIMUM_BOTTOM_MARGIN = 10;
    private static final int DEFAULT_HORIZONTAL_ALIGNMENT = 0;
    private static final int DEFAULT_VERTICAL_ALIGNMENT = 0;
    private int horizontalSpacing;
    private int verticalSpacing;
    private int minLeftMargin;
    private int minRightMargin;
    private int minTopMargin;
    private int minBottomMargin;
    private int horizontalAlignment;
    private int verticalAlignment;

    public FitAllLayout() {
        this(0, 0, 10, 10, 10, 10, 10, 10);
    }

    public FitAllLayout(int n, int n2) throws IllegalArgumentException {
        this(n, n2, 10, 10, 10, 10, 10, 10);
    }

    public FitAllLayout(int n, int n2, int n3, int n4, int n5, int n6) throws IllegalArgumentException {
        this(0, 0, n, n2, n3, n4, n5, n6);
    }

    public FitAllLayout(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) throws IllegalArgumentException {
        Utility.checkHorizontalAlignment(n);
        Utility.checkVerticalAlignment(n2);
        Utility.checkSpacing(n3, n4);
        Utility.checkMargins(n5, n6, n7, n8);
        this.horizontalAlignment = n;
        this.verticalAlignment = n2;
        this.horizontalSpacing = n3;
        this.verticalSpacing = n4;
        this.minLeftMargin = n5;
        this.minRightMargin = n6;
        this.minTopMargin = n7;
        this.minBottomMargin = n8;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FitAllLayout)) {
            return false;
        }
        FitAllLayout fitAllLayout = (FitAllLayout)object;
        return this.minLeftMargin == fitAllLayout.minLeftMargin && this.minRightMargin == fitAllLayout.minRightMargin && this.minTopMargin == fitAllLayout.minTopMargin && this.minBottomMargin == fitAllLayout.minBottomMargin && this.horizontalSpacing == fitAllLayout.horizontalSpacing && this.verticalSpacing == fitAllLayout.verticalSpacing && this.horizontalAlignment == fitAllLayout.horizontalAlignment && this.verticalAlignment == fitAllLayout.verticalAlignment;
    }

    public Dimension getPreferredScrollableViewportSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public int hashCode() {
        return Utility.computeHashCode(this.horizontalAlignment, this.verticalAlignment, this.horizontalSpacing, this.verticalSpacing, this.minLeftMargin, this.minRightMargin, this.minTopMargin, this.minBottomMargin);
    }

    public double preferredScale(Container container) {
        Container container2 = container.getParent();
        if (container2 == null) {
            return 0.0;
        }
        Dimension dimension = container2.getSize();
        double d = dimension.getWidth();
        double d2 = dimension.getHeight();
        if (d == 0.0 || d2 == 0.0) {
            return 1.0;
        }
        Insets insets = container.getInsets();
        int n = (int)d - insets.left - insets.right;
        int n2 = (int)d2 - insets.top - insets.bottom;
        int n3 = container.getComponentCount();
        if (n3 == 0) {
            return 1.0;
        }
        LayoutSupport layoutSupport = LayoutSupport.getSupport(container);
        double d3 = layoutSupport.getMaximumFixedWidth();
        double d4 = layoutSupport.getMaximumFixedHeight();
        double d5 = layoutSupport.getMaximumPreferredScaleableWidth();
        double d6 = layoutSupport.getMaximumPreferredScaleableHeight();
        int n4 = 1;
        int n5 = 1;
        double d7 = 0.0;
        int n6 = 1;
        while (n6 <= n3) {
            double d8;
            double d9;
            double d10;
            double d11;
            double d12;
            int n7 = n3 / n6;
            if (n3 % n6 != 0) {
                ++n7;
            }
            if ((d12 = Math.min(d11 = (d10 = ((double)(n - this.minLeftMargin - this.minRightMargin - (n6 - 1) * this.horizontalSpacing) - (double)n6 * d3) / (double)n6) / d5, d9 = (d8 = ((double)(n2 - this.minTopMargin - this.minBottomMargin - (n7 - 1) * this.verticalSpacing) - (double)n7 * d4) / (double)n7) / d6)) > d7) {
                n4 = n6;
                n5 = n7;
                d7 = d12;
            }
            ++n6;
        }
        return d7;
    }

    public int getScrollableBlockIncrement(Container container, Rectangle rectangle, int n, int n2) {
        return 0;
    }

    public boolean getScrollableTracksViewportHeight(Container container) {
        return true;
    }

    public boolean getScrollableTracksViewportWidth(Container container) {
        return true;
    }

    public int getScrollableUnitIncrement(Container container, Rectangle rectangle, int n, int n2) {
        return 0;
    }

    private Dimension idealPreferredLayoutSize(Container container) {
        LayoutSupport layoutSupport = LayoutSupport.getSupport(container);
        return layoutSupport.getLinearDimensions(1.0, this.horizontalSpacing, this.verticalSpacing, this.minLeftMargin, this.minRightMargin, this.minTopMargin, this.minBottomMargin);
    }

    public void layoutContainer(Container container) {
        this.scaleComponents(container);
    }

    public double scaleComponents(Container container) {
        return this.doScaleComponents(container, true);
    }

    private double doScaleComponents(Container container, boolean bl) {
        int n;
        int n2;
        int n3;
        Dimension dimension = container.getSize();
        Insets insets = container.getInsets();
        int n4 = (int)dimension.getWidth() - insets.left - insets.right;
        int n5 = (int)dimension.getHeight() - insets.top - insets.bottom;
        int n6 = container.getComponentCount();
        if (n6 == 0) {
            return 1.0;
        }
        LayoutSupport layoutSupport = LayoutSupport.getSupport(container);
        double d = layoutSupport.getMaximumFixedWidth();
        double d2 = layoutSupport.getMaximumFixedHeight();
        double d3 = layoutSupport.getMaximumPreferredScaleableWidth();
        double d4 = layoutSupport.getMaximumPreferredScaleableHeight();
        int n7 = 1;
        int n8 = 1;
        double d5 = 0.0;
        int n9 = 1;
        while (n9 <= n6) {
            double d6;
            double d7;
            double d8;
            double d9;
            double d10;
            n3 = n6 / n9;
            if (n6 % n9 != 0) {
                ++n3;
            }
            if ((d10 = Math.min(d9 = (d8 = ((double)(n4 - this.minLeftMargin - this.minRightMargin - (n9 - 1) * this.horizontalSpacing) - (double)n9 * d) / (double)n9) / d3, d7 = (d6 = ((double)(n5 - this.minTopMargin - this.minBottomMargin - (n3 - 1) * this.verticalSpacing) - (double)n3 * d2) / (double)n3) / d4)) > d5) {
                n7 = n9;
                n8 = n3;
                d5 = d10;
            }
            ++n9;
        }
        if (!bl) {
            return d5;
        }
        n3 = (int)(d + d3 * d5);
        int n10 = (int)(d2 + d4 * d5);
        int n11 = n4 - n7 * n3 - (n7 - 1) * this.horizontalSpacing - this.minLeftMargin - this.minRightMargin;
        int n12 = n2 = n11 / 2;
        if (n11 % 2 != 0) {
            ++n12;
        }
        int n13 = this.minLeftMargin + n2;
        int n14 = this.minRightMargin + n12;
        int n15 = n5 - n8 * n10 - (n8 - 1) * this.verticalSpacing - this.minTopMargin - this.minBottomMargin;
        int n16 = n = n15 / 2;
        if (n15 % 2 != 0) {
            ++n15;
        }
        int n17 = this.minTopMargin + n;
        int n18 = this.minBottomMargin + n16;
        layoutSupport.layoutComponents(n8, n7, n3, n10, d5, this.horizontalSpacing, this.verticalSpacing, n13, n14, n17, n18, this.horizontalAlignment, this.verticalAlignment);
        return d5;
    }

    public Dimension minimumLayoutSize(Container container) {
        LayoutSupport layoutSupport = LayoutSupport.getSupport(container);
        return layoutSupport.getLinearDimensions(0.01, this.horizontalSpacing, this.verticalSpacing, this.minLeftMargin, this.minRightMargin, this.minTopMargin, this.minBottomMargin);
    }

    public Dimension preferredLayoutSize(Container container) {
        Container container2 = container.getParent();
        if (container2 == null) {
            return new Dimension(0, 0);
        }
        Dimension dimension = container2.getSize();
        double d = dimension.getWidth();
        double d2 = dimension.getHeight();
        if (d == 0.0 || d2 == 0.0) {
            return this.idealPreferredLayoutSize(container);
        }
        return dimension;
    }

    public void removeLayoutComponent(Component component) {
    }
}

