/*
 * Decompiled with CFR 0.152.
 */
package sos.preview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.io.Serializable;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.border.Border;
import sos.preview.JPrintPreviewPane;
import sos.preview.PageNumberRenderer;

public class DefaultPageNumberRenderer
implements PageNumberRenderer,
Serializable {
    private static final JLabel label = new CustomLabel();
    private static final Border noFocusBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);

    public Component getPageNumberRendererComponent(JPrintPreviewPane jPrintPreviewPane, int n, boolean bl, boolean bl2) {
        String string = this.pageNumberToString(n);
        label.setText(string);
        this.prepareLabel(label, jPrintPreviewPane, n, bl, bl2);
        return label;
    }

    protected String pageNumberToString(int n) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        return numberFormat.format(new Integer(n));
    }

    protected void prepareLabel(JLabel jLabel, JPrintPreviewPane jPrintPreviewPane, int n, boolean bl, boolean bl2) {
        if (bl) {
            jLabel.setForeground(jPrintPreviewPane.getSelectionForeground());
        } else {
            jLabel.setForeground(jPrintPreviewPane.getForeground());
        }
        jLabel.setIcon(null);
        jLabel.setHorizontalAlignment(0);
        jLabel.setComponentOrientation(jPrintPreviewPane.getComponentOrientation());
        jLabel.setFont(jPrintPreviewPane.getFont());
        jLabel.setEnabled(jPrintPreviewPane.isEnabled());
        if (bl2) {
            jLabel.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, Color.orange));
        } else {
            jLabel.setBorder(noFocusBorder);
        }
    }

    private static class CustomLabel
    extends JLabel {
        private CustomLabel() {
        }

        public void firePropertyChange(String string, boolean bl, boolean bl2) {
        }

        public void invalidate() {
        }

        public void revalidate() {
        }

        public void repaint(long l, int n, int n2, int n3, int n4) {
        }

        public void repaint(Rectangle rectangle) {
        }

        public void repaint() {
        }

        public void validate() {
        }

        protected void firePropertyChange(String string, Object object, Object object2) {
            if (string == "text") {
                super.firePropertyChange(string, object, object2);
            }
        }

        protected void setValue(Object object) {
            this.setText(object == null ? "" : object.toString());
        }
    }
}

