/*
 * Decompiled with CFR 0.152.
 */
package sos.preview;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.JComponent;
import sos.preview.Utility;

public class ComponentPageable
implements Pageable {
    private JComponent component;
    private PageFormat pageFormat;
    private int numColumns;
    private int numRows;
    private double scaleX;
    private double scaleY;

    public ComponentPageable(JComponent jComponent, PageFormat pageFormat) {
        Utility.checkNull(jComponent, "component");
        Utility.checkNull(pageFormat, "page format");
        this.component = jComponent;
        this.pageFormat = pageFormat;
        if (jComponent.getWidth() == 0 && jComponent.getHeight() == 0) {
            jComponent.addNotify();
            jComponent.setSize(jComponent.getPreferredSize());
            jComponent.validate();
        }
        this.size(jComponent.getWidth(), jComponent.getHeight());
        this.scale(1.0, 1.0);
    }

    public void fit(boolean bl) {
        int n = this.component.getWidth();
        int n2 = this.component.getHeight();
        double d = this.pageFormat.getImageableWidth() / (double)n;
        double d2 = this.pageFormat.getImageableHeight() / (double)n2;
        if (d < 1.0 || d2 < 1.0) {
            if (bl) {
                if (d < d2) {
                    d2 = d;
                } else {
                    d = d2;
                }
            }
            this.size((double)n * d, (double)n2 * d2);
            this.scale(d, d2);
        }
    }

    public void fitHeight(boolean bl) {
        double d;
        int n = this.component.getHeight();
        if ((double)n <= (d = this.pageFormat.getImageableHeight())) {
            return;
        }
        double d2 = d / (double)n;
        double d3 = bl ? d2 : 1.0;
        int n2 = this.component.getWidth();
        this.size((double)n2 * d3, d);
        this.scale(d3, d2);
    }

    public void fitWidth(boolean bl) {
        double d;
        int n = this.component.getWidth();
        if ((double)n <= (d = this.pageFormat.getImageableWidth())) {
            return;
        }
        double d2 = d / (double)n;
        double d3 = bl ? d2 : 1.0;
        int n2 = this.component.getHeight();
        this.size(d, (double)n2 * d3);
        this.scale(d2, d3);
    }

    public int getNumberOfPages() {
        return this.numColumns * this.numRows;
    }

    public PageFormat getPageFormat(int n) throws IndexOutOfBoundsException {
        if (n >= this.numColumns * this.numRows) {
            throw new IndexOutOfBoundsException();
        }
        return this.pageFormat;
    }

    public Printable getPrintable(int n) throws IndexOutOfBoundsException {
        if (n >= this.numColumns * this.numRows) {
            throw new IndexOutOfBoundsException();
        }
        double d = (double)(n % this.numColumns) * this.pageFormat.getImageableWidth();
        double d2 = (double)(n / this.numColumns) * this.pageFormat.getImageableHeight();
        return new ComponentPrintable(d, d2);
    }

    private void scale(double d, double d2) {
        this.scaleX = d;
        this.scaleY = d2;
    }

    private void size(double d, double d2) {
        double d3 = this.pageFormat.getImageableWidth();
        double d4 = this.pageFormat.getImageableHeight();
        this.numColumns = (int)((d + d3 - 1.0) / d3);
        this.numRows = (int)((d2 + d4 - 1.0) / d4);
    }

    class ComponentPrintable
    implements Printable {
        private double originX;
        private double originY;

        public ComponentPrintable(double d, double d2) {
            this.originX = d;
            this.originY = d2;
        }

        public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
            Graphics2D graphics2D = (Graphics2D)graphics;
            double d = -this.originX + pageFormat.getImageableX();
            double d2 = -this.originY + pageFormat.getImageableY();
            graphics2D.translate(d, d2);
            graphics2D.scale(ComponentPageable.this.scaleX, ComponentPageable.this.scaleY);
            boolean bl = ComponentPageable.this.component.isDoubleBuffered();
            ComponentPageable.this.component.setDoubleBuffered(false);
            ComponentPageable.this.component.printAll(graphics2D);
            ComponentPageable.this.component.setDoubleBuffered(bl);
            graphics2D.translate(-d, -d2);
            return 0;
        }
    }
}

