/*
 * Decompiled with CFR 0.152.
 */
package sos.preview;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import sos.preview.BasicPrintPreviewPageUI;
import sos.preview.Utility;

public class CachingPageable
implements Pageable {
    private Pageable pageable;
    private boolean memorySensitive;
    private CachingPrintable cachingPrintable;
    private List bufferedImages;

    public CachingPageable(Pageable pageable) {
        this(pageable, true);
    }

    public CachingPageable(Pageable pageable, boolean bl) {
        Utility.checkNull(pageable, "pageable");
        this.pageable = pageable;
        this.memorySensitive = bl;
        this.cachingPrintable = new CachingPrintable();
        int n = pageable.getNumberOfPages();
        this.bufferedImages = new ArrayList(n);
        int n2 = 0;
        while (n2 < n) {
            this.bufferedImages.add(null);
            ++n2;
        }
    }

    public int getNumberOfPages() {
        return this.pageable.getNumberOfPages();
    }

    public PageFormat getPageFormat(int n) throws IndexOutOfBoundsException {
        return this.pageable.getPageFormat(n);
    }

    public Printable getPrintable(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.getNumberOfPages()) {
            throw new IndexOutOfBoundsException();
        }
        return this.cachingPrintable;
    }

    class CachingPrintable
    implements Printable {
        CachingPrintable() {
        }

        public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
            BufferedImage bufferedImage = null;
            Object e = CachingPageable.this.bufferedImages.get(n);
            if (e instanceof Reference) {
                bufferedImage = (BufferedImage)((Reference)e).get();
            } else if (e instanceof BufferedImage) {
                bufferedImage = (BufferedImage)e;
            }
            if (bufferedImage == null) {
                int n2 = (int)pageFormat.getWidth();
                int n3 = (int)pageFormat.getHeight();
                bufferedImage = new BufferedImage(n2, n3, 2);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.addRenderingHints(BasicPrintPreviewPageUI.hints);
                Printable printable = CachingPageable.this.pageable.getPrintable(n);
                printable.print(graphics2D, pageFormat, n);
                if (CachingPageable.this.memorySensitive) {
                    CachingPageable.this.bufferedImages.set(n, new SoftReference<BufferedImage>(bufferedImage));
                } else {
                    CachingPageable.this.bufferedImages.set(n, bufferedImage);
                }
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.drawImage(bufferedImage, null, 0, 0);
            return 0;
        }
    }
}

