/*
 * Decompiled with CFR 0.152.
 */
package sos.preview;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.print.Pageable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.ListSelectionModel;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import sos.preview.FitAllLayout;
import sos.preview.FitLayout;
import sos.preview.JPrintPreviewPane;
import sos.preview.MatrixLayout;
import sos.preview.PrintPreviewPaneUI;
import sos.preview.Utility;
import sos.preview.ZoomLayout;

public class BasicPrintPreviewPaneUI
extends PrintPreviewPaneUI {
    public static final Object BACKGROUND_KEY = "sos.preview.JPrintPreviewPane.background";
    public static final Object BOTTOM_MARGIN = "sos.preview.JPrintPreviewPane.bottomMargin";
    public static final Object FOREGROUND_KEY = "sos.preview.JPrintPreviewPane.foreground";
    public static final Object LEFT_MARGIN = "sos.preview.JPrintPreviewPane.leftMargin";
    public static final Object HORIZONTAL_ALIGNMENT = "sos.preview.JPrintPreviewPane.horizontalAlignment";
    public static final Object HORIZONTAL_SPACING = "sos.preview.JPrintPreviewPane.horizontalSpacing";
    public static final Object RIGHT_MARGIN = "sos.preview.JPrintPreviewPane.rightMargin";
    public static final Object SELECTION_BACKGROUND_KEY = "sos.preview.JPrintPreviewPane.selectionBackground";
    public static final Object SELECTION_FOREGROUND_KEY = "sos.preview.JPrintPreviewPane.selectionForeground";
    public static final Object TOP_MARGIN = "sos.preview.JPrintPreviewPane.topMargin";
    public static final Object VERTICAL_ALIGNMENT = "sos.preview.JPrintPreviewPane.verticalAlignment";
    public static final Object VERTICAL_SPACING = "sos.preview.JPrintPreviewPane.verticalSpacing";
    protected JPrintPreviewPane printPreviewPane;
    private Listener listener;
    private PropertyChangeListener propertyChangeListener;
    private MouseInputListener mouseInputListener;
    private ListSelectionListener selectionListener;
    int horizontalAlignment;
    int verticalAlignment;
    int horizontalSpacing;
    int verticalSpacing;
    int leftMargin;
    int rightMargin;
    int topMargin;
    int bottomMargin;
    static /* synthetic */ Class class$sos$preview$BasicPrintPreviewPaneUI;

    public LayoutManager createFitAllLayout(JPrintPreviewPane jPrintPreviewPane) {
        return new FitAllLayout(this.horizontalAlignment, this.verticalAlignment, this.horizontalSpacing, this.verticalSpacing, this.leftMargin, this.rightMargin, this.topMargin, this.bottomMargin);
    }

    public LayoutManager createFitLayout(JPrintPreviewPane jPrintPreviewPane) {
        int n = jPrintPreviewPane.getComponentOrientation().isHorizontal() ? this.verticalSpacing : this.horizontalSpacing;
        return new FitLayout(2, this.horizontalAlignment, this.verticalAlignment, n, this.leftMargin, this.rightMargin, this.topMargin, this.bottomMargin);
    }

    public LayoutManager createMatrixLayout(JPrintPreviewPane jPrintPreviewPane, int n, int n2) {
        return new MatrixLayout(n, n2, this.horizontalAlignment, this.verticalAlignment, this.horizontalSpacing, this.verticalSpacing, this.leftMargin, this.rightMargin, this.topMargin, this.bottomMargin);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return this.getListener();
    }

    protected Cursor createSelectionCursor() {
        Cursor cursor = Cursor.getPredefinedCursor(0);
        return cursor;
    }

    protected ListSelectionListener createSelectionListener() {
        return this.getListener();
    }

    protected MouseInputListener createSelectionMouseInputListener() {
        return this.getListener();
    }

    public LayoutManager createZoomLayout(JPrintPreviewPane jPrintPreviewPane, double d) {
        return new ZoomLayout(d, this.horizontalAlignment, this.verticalAlignment, this.horizontalSpacing, this.verticalSpacing, this.leftMargin, this.rightMargin, this.topMargin, this.bottomMargin);
    }

    protected Cursor createZoomCursor() {
        Point point = new Point(8, 8);
        return Utility.loadCursor(this, "toolbarButtonGraphics/general/Zoom24.gif", point, "Zoom");
    }

    protected Cursor createZoomInCursor() {
        Point point = new Point(8, 8);
        return Utility.loadCursor(this, "toolbarButtonGraphics/general/ZoomIn24.gif", point, "Zoom In");
    }

    protected Cursor createZoomOutCursor() {
        Point point = new Point(8, 8);
        return Utility.loadCursor(this, "toolbarButtonGraphics/general/ZoomOut24.gif", point, "Zoom Out");
    }

    protected MouseInputListener createZoomMouseInputListener() {
        return new ZoomHandler(1);
    }

    protected MouseInputListener createZoomInMouseInputListener() {
        return new ZoomHandler(2);
    }

    protected MouseInputListener createZoomOutMouseInputListener() {
        return new ZoomHandler(3);
    }

    private Listener getListener() {
        if (this.listener == null) {
            this.listener = new Listener();
        }
        return this.listener;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicPrintPreviewPaneUI();
    }

    protected void installDefaults() {
        Color color;
        Utility.installDefaultBackground(this.printPreviewPane, BACKGROUND_KEY);
        Color color2 = this.printPreviewPane.getSelectionBackground();
        if (color2 == null || color2 instanceof UIResource) {
            color2 = UIManager.getColor(SELECTION_BACKGROUND_KEY);
            this.printPreviewPane.setSelectionBackground(color2);
        }
        if ((color = this.printPreviewPane.getSelectionForeground()) == null || color instanceof UIResource) {
            color = UIManager.getColor(SELECTION_FOREGROUND_KEY);
            this.printPreviewPane.setSelectionForeground(color);
        }
        this.horizontalAlignment = UIManager.getInt(HORIZONTAL_ALIGNMENT);
        this.verticalAlignment = UIManager.getInt(VERTICAL_ALIGNMENT);
        this.horizontalSpacing = UIManager.getInt(HORIZONTAL_SPACING);
        this.horizontalSpacing = Math.max(0, this.horizontalSpacing);
        this.verticalSpacing = UIManager.getInt(VERTICAL_SPACING);
        this.verticalSpacing = Math.max(0, this.verticalSpacing);
        this.leftMargin = UIManager.getInt(LEFT_MARGIN);
        this.leftMargin = Math.max(0, this.leftMargin);
        this.rightMargin = UIManager.getInt(RIGHT_MARGIN);
        this.rightMargin = Math.max(0, this.rightMargin);
        this.topMargin = UIManager.getInt(TOP_MARGIN);
        this.topMargin = Math.max(0, this.topMargin);
        this.bottomMargin = UIManager.getInt(BOTTOM_MARGIN);
        this.bottomMargin = Math.max(0, this.bottomMargin);
    }

    public void installUI(JComponent jComponent) {
        this.printPreviewPane = (JPrintPreviewPane)jComponent;
        this.installDefaults();
        this.installListeners();
    }

    protected void installListeners() {
        this.installMouseListeners();
        this.selectionListener = this.createSelectionListener();
        this.propertyChangeListener = this.createPropertyChangeListener();
        ListSelectionModel listSelectionModel = this.printPreviewPane.getPageSelectionModel();
        if (listSelectionModel != null) {
            listSelectionModel.addListSelectionListener(this.selectionListener);
        }
        this.printPreviewPane.addPropertyChangeListener(this.propertyChangeListener);
    }

    private void installMouseListeners() {
        Cursor cursor;
        int n = this.printPreviewPane.getMode();
        switch (n) {
            case 0: {
                this.mouseInputListener = this.createSelectionMouseInputListener();
                cursor = this.createSelectionCursor();
                break;
            }
            case 1: {
                this.mouseInputListener = this.createZoomMouseInputListener();
                cursor = this.createZoomCursor();
                break;
            }
            case 2: {
                this.mouseInputListener = this.createZoomInMouseInputListener();
                cursor = this.createZoomInCursor();
                break;
            }
            case 3: {
                this.mouseInputListener = this.createZoomOutMouseInputListener();
                cursor = this.createZoomOutCursor();
                break;
            }
            default: {
                throw new AssertionError((Object)"Unrecognized print preview pane mode.");
            }
        }
        this.printPreviewPane.addMouseListener(this.mouseInputListener);
        this.printPreviewPane.addMouseMotionListener(this.mouseInputListener);
        this.installPageCursor(cursor);
    }

    private void installPageCursor(Cursor cursor) {
        Pageable pageable = this.printPreviewPane.getPageable();
        int n = pageable.getNumberOfPages();
        int n2 = 0;
        while (n2 < n) {
            Component component = this.printPreviewPane.getPageComponent(n2);
            component.setCursor(cursor);
            ++n2;
        }
    }

    protected void uninstallDefaults() {
        Color color;
        Utility.uninstallDefaultBackground(this.printPreviewPane);
        Color color2 = this.printPreviewPane.getSelectionBackground();
        if (color2 instanceof UIResource) {
            this.printPreviewPane.setSelectionBackground(null);
        }
        if ((color = this.printPreviewPane.getSelectionForeground()) instanceof UIResource) {
            this.printPreviewPane.setSelectionForeground(null);
        }
    }

    protected void uninstallListeners() {
        ListSelectionModel listSelectionModel = this.printPreviewPane.getPageSelectionModel();
        if (listSelectionModel != null) {
            listSelectionModel.removeListSelectionListener(this.selectionListener);
        }
        this.printPreviewPane.removeMouseListener(this.mouseInputListener);
        this.printPreviewPane.removeMouseMotionListener(this.mouseInputListener);
        this.printPreviewPane.removePropertyChangeListener(this.propertyChangeListener);
        this.selectionListener = null;
        this.mouseInputListener = null;
        this.propertyChangeListener = null;
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallListeners();
        this.uninstallDefaults();
        this.printPreviewPane = null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Utility.initDefault(BACKGROUND_KEY, new ColorUIResource(Color.gray.brighter()));
        Utility.initDefault(SELECTION_BACKGROUND_KEY, null);
        Utility.initDefault(SELECTION_FOREGROUND_KEY, new ColorUIResource(Color.blue));
        Integer n = new Integer(0);
        Utility.initDefault(HORIZONTAL_ALIGNMENT, n);
        Utility.initDefault(VERTICAL_ALIGNMENT, n);
        Integer n2 = new Integer(10);
        Utility.initDefault(HORIZONTAL_SPACING, n2);
        Utility.initDefault(VERTICAL_SPACING, n2);
        Utility.initDefault(LEFT_MARGIN, n2);
        Utility.initDefault(RIGHT_MARGIN, n2);
        Utility.initDefault(TOP_MARGIN, n2);
        Utility.initDefault(BOTTOM_MARGIN, n2);
    }

    class Listener
    implements MouseInputListener,
    ListSelectionListener,
    PropertyChangeListener {
        private boolean selectedOnPress;
        static final /* synthetic */ boolean $assertionsDisabled;

        Listener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            if (!BasicPrintPreviewPaneUI.this.printPreviewPane.isEnabled()) {
                return;
            }
            if (mouseEvent.isConsumed()) {
                this.selectedOnPress = false;
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            if (mouseEvent.isShiftDown() || mouseEvent.isControlDown()) {
                return;
            }
            int n2 = mouseEvent.getClickCount();
            if (n2 != 2) {
                return;
            }
            int n3 = mouseEvent.getX();
            int n4 = BasicPrintPreviewPaneUI.this.printPreviewPane.getPageIndexAt(n3, n = mouseEvent.getY());
            if (n4 < 0) {
                return;
            }
            LayoutManager layoutManager = BasicPrintPreviewPaneUI.this.printPreviewPane.getLayout();
            if (!Utility.isOnePageLayout(layoutManager)) {
                layoutManager = BasicPrintPreviewPaneUI.this.createMatrixLayout(BasicPrintPreviewPaneUI.this.printPreviewPane, 1, 1);
                BasicPrintPreviewPaneUI.this.printPreviewPane.setLayout(layoutManager);
                BasicPrintPreviewPaneUI.this.printPreviewPane.doLayout();
            }
            BasicPrintPreviewPaneUI.this.printPreviewPane.centerPage(n4);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n;
            if (!BasicPrintPreviewPaneUI.this.printPreviewPane.getPageSelectionAllowed()) {
                return;
            }
            ListSelectionModel listSelectionModel = BasicPrintPreviewPaneUI.this.printPreviewPane.getPageSelectionModel();
            if (mouseEvent.isConsumed()) {
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            if (!BasicPrintPreviewPaneUI.this.printPreviewPane.isEnabled()) {
                return;
            }
            if (mouseEvent.isShiftDown() || mouseEvent.isControlDown()) {
                return;
            }
            int n2 = mouseEvent.getX();
            int n3 = BasicPrintPreviewPaneUI.this.printPreviewPane.getPageIndexAt(n2, n = mouseEvent.getY());
            if (n3 < 0) {
                return;
            }
            listSelectionModel.setSelectionInterval(n3, n3);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!BasicPrintPreviewPaneUI.this.printPreviewPane.getPageSelectionAllowed()) {
                return;
            }
            ListSelectionModel listSelectionModel = BasicPrintPreviewPaneUI.this.printPreviewPane.getPageSelectionModel();
            if (mouseEvent.isConsumed()) {
                this.selectedOnPress = false;
                return;
            }
            this.selectedOnPress = true;
            this.updateSelection(mouseEvent, listSelectionModel);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!BasicPrintPreviewPaneUI.this.printPreviewPane.getPageSelectionAllowed()) {
                return;
            }
            ListSelectionModel listSelectionModel = BasicPrintPreviewPaneUI.this.printPreviewPane.getPageSelectionModel();
            if (this.selectedOnPress) {
                if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    return;
                }
                listSelectionModel.setValueIsAdjusting(false);
            } else {
                this.updateSelection(mouseEvent, listSelectionModel);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        private void updateSelection(MouseEvent mouseEvent, ListSelectionModel listSelectionModel) {
            int n;
            int n2;
            int n3;
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            if (!BasicPrintPreviewPaneUI.this.printPreviewPane.isEnabled()) {
                return;
            }
            if (!BasicPrintPreviewPaneUI.this.printPreviewPane.hasFocus() && BasicPrintPreviewPaneUI.this.printPreviewPane.isRequestFocusEnabled()) {
                BasicPrintPreviewPaneUI.this.printPreviewPane.requestFocus();
            }
            if ((n3 = BasicPrintPreviewPaneUI.this.printPreviewPane.getPageIndexAt(n2 = mouseEvent.getX(), n = mouseEvent.getY())) < 0) {
                listSelectionModel.clearSelection();
                return;
            }
            boolean bl = mouseEvent.getID() == 501;
            listSelectionModel.setValueIsAdjusting(bl);
            int n4 = listSelectionModel.getAnchorSelectionIndex();
            if (mouseEvent.isControlDown()) {
                if (listSelectionModel.isSelectedIndex(n3)) {
                    listSelectionModel.removeSelectionInterval(n3, n3);
                } else {
                    listSelectionModel.addSelectionInterval(n3, n3);
                }
            } else if (mouseEvent.isShiftDown() && n4 != -1) {
                listSelectionModel.setSelectionInterval(n4, n3);
            } else {
                listSelectionModel.setSelectionInterval(n3, n3);
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = listSelectionEvent.getFirstIndex();
            int n2 = listSelectionEvent.getLastIndex();
            RepaintManager repaintManager = RepaintManager.currentManager(BasicPrintPreviewPaneUI.this.printPreviewPane);
            int n3 = n;
            while (n3 <= n2) {
                Component component = BasicPrintPreviewPaneUI.this.printPreviewPane.getComponent(n3);
                int n4 = component.getX();
                int n5 = component.getY();
                int n6 = component.getWidth();
                int n7 = component.getHeight();
                repaintManager.addDirtyRegion(BasicPrintPreviewPaneUI.this.printPreviewPane, n4, n5, n6, n7);
                ++n3;
            }
            repaintManager.paintDirtyRegions();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            Object object = propertyChangeEvent.getOldValue();
            Object object2 = propertyChangeEvent.getNewValue();
            if ("mode".equals(string)) {
                BasicPrintPreviewPaneUI.this.printPreviewPane.removeMouseListener(BasicPrintPreviewPaneUI.this.mouseInputListener);
                BasicPrintPreviewPaneUI.this.printPreviewPane.removeMouseMotionListener(BasicPrintPreviewPaneUI.this.mouseInputListener);
                if (!$assertionsDisabled && object2 == null) {
                    throw new AssertionError();
                }
                BasicPrintPreviewPaneUI.this.installMouseListeners();
            } else if ("layout".equals(string)) {
                BasicPrintPreviewPaneUI.this.printPreviewPane.revalidate();
                BasicPrintPreviewPaneUI.this.printPreviewPane.repaint();
            } else if ("pageable".equals(string)) {
                Cursor cursor;
                BasicPrintPreviewPaneUI.this.printPreviewPane.revalidate();
                BasicPrintPreviewPaneUI.this.printPreviewPane.repaint();
                ListSelectionModel listSelectionModel = BasicPrintPreviewPaneUI.this.printPreviewPane.getPageSelectionModel();
                if (listSelectionModel != null) {
                    listSelectionModel.clearSelection();
                }
                int n = BasicPrintPreviewPaneUI.this.printPreviewPane.getMode();
                switch (n) {
                    case 0: {
                        cursor = BasicPrintPreviewPaneUI.this.createSelectionCursor();
                        break;
                    }
                    case 1: {
                        cursor = BasicPrintPreviewPaneUI.this.createZoomCursor();
                        break;
                    }
                    case 2: {
                        cursor = BasicPrintPreviewPaneUI.this.createZoomInCursor();
                        break;
                    }
                    case 3: {
                        cursor = BasicPrintPreviewPaneUI.this.createZoomOutCursor();
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)"Unrecognized print preview pane mode.");
                    }
                }
                BasicPrintPreviewPaneUI.this.installPageCursor(cursor);
            } else if ("selectionForeground".equals(string)) {
                BasicPrintPreviewPaneUI.this.printPreviewPane.repaint();
            } else if ("selectionBackground".equals(string)) {
                BasicPrintPreviewPaneUI.this.printPreviewPane.repaint();
            } else if ("marginsAreShown".equals(string)) {
                BasicPrintPreviewPaneUI.this.printPreviewPane.repaint();
            } else if ("pageNumberRenderer".equals(string)) {
                BasicPrintPreviewPaneUI.this.printPreviewPane.revalidate();
                BasicPrintPreviewPaneUI.this.printPreviewPane.repaint();
            } else if ("pageNumbersAreShown".equals(string)) {
                BasicPrintPreviewPaneUI.this.printPreviewPane.revalidate();
                BasicPrintPreviewPaneUI.this.printPreviewPane.repaint();
            } else if ("selectionModel".equals(string)) {
                ListSelectionModel listSelectionModel;
                ListSelectionModel listSelectionModel2 = (ListSelectionModel)object;
                if (listSelectionModel2 != null) {
                    listSelectionModel2.removeListSelectionListener(BasicPrintPreviewPaneUI.this.selectionListener);
                }
                if ((listSelectionModel = (ListSelectionModel)object2) != null) {
                    listSelectionModel.addListSelectionListener(BasicPrintPreviewPaneUI.this.selectionListener);
                }
                BasicPrintPreviewPaneUI.this.printPreviewPane.repaint();
            } else if ("pageSelectionAllowed".equals(string)) {
                BasicPrintPreviewPaneUI.this.printPreviewPane.repaint();
            } else if ("componentOrientation".equals(string)) {
                ComponentOrientation componentOrientation = (ComponentOrientation)object2;
                BasicPrintPreviewPaneUI.this.printPreviewPane.applyComponentOrientation(componentOrientation);
            } else if ("locale".equals(string)) {
                BasicPrintPreviewPaneUI.this.printPreviewPane.revalidate();
                BasicPrintPreviewPaneUI.this.printPreviewPane.repaint();
            }
        }

        static {
            $assertionsDisabled = !(class$sos$preview$BasicPrintPreviewPaneUI == null ? (class$sos$preview$BasicPrintPreviewPaneUI = BasicPrintPreviewPaneUI.class$("sos.preview.BasicPrintPreviewPaneUI")) : class$sos$preview$BasicPrintPreviewPaneUI).desiredAssertionStatus();
        }
    }

    class ZoomHandler
    extends MouseInputAdapter {
        private int mode;

        ZoomHandler(int n) {
            this.mode = n;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            switch (this.mode) {
                case 1: {
                    if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                        BasicPrintPreviewPaneUI.this.printPreviewPane.zoomOut(point);
                        break;
                    }
                    BasicPrintPreviewPaneUI.this.printPreviewPane.zoomIn(point);
                    break;
                }
                case 2: {
                    BasicPrintPreviewPaneUI.this.printPreviewPane.zoomIn(point);
                    break;
                }
                case 3: {
                    BasicPrintPreviewPaneUI.this.printPreviewPane.zoomOut(point);
                }
            }
        }
    }
}

