/*
 * Decompiled with CFR 0.152.
 */
package sos.preview;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import sos.preview.JPrintPreviewPage;
import sos.preview.JPrintPreviewPane;
import sos.preview.PageNumberRenderer;
import sos.preview.PrintPreviewPageUI;
import sos.preview.Utility;

public class BasicPrintPreviewPageUI
extends PrintPreviewPageUI {
    public static final Object BORDER_THICKNESS_KEY = "sos.preview.JPrintPreviewPage.borderThickness";
    public static final Object SHADOW_THICKNESS_KEY = "sos.preview.JPrintPreviewPage.shadowThickness";
    public static final Object BACKGROUND_KEY = "sos.preview.JPrintPreviewPage.background";
    public static final Object FOREGROUND_KEY = "sos.preview.JPrintPreviewPage.foreground";
    public static final Object SHADOW_COLOR_KEY = "sos.preview.JPrintPreviewPage.shadowColor";
    public static final Object MARGIN_COLOR_KEY = "sos.preview.JPrintPreviewPage.marginColor";
    public static final Object MARGIN_STROKE_KEY = "sos.preview.JPrintPreviewPage.marginStroke";
    public static final Object CACHING_POLICY_KEY = "sos.preview.JPrintPreviewPage.cachingPolicy";
    public static final Object ALWAYS_CACHE_VALUE = "alwaysCache";
    public static final Object NEVER_CACHE_VALUE = "neverCache";
    public static final Object MEMORY_SENSITIVE_CACHE_VALUE = "memorySensitiveCache";
    static final Map hints = new HashMap();
    private JPrintPreviewPage printPreviewPage;
    private CellRendererPane rendererPane;
    private int borderThickness;
    private int shadowThickness;
    private Color shadowColor;
    private Color marginColor;
    private Stroke marginStroke;
    private Object cachingPolicy;
    private double cachedScale;
    private Object cachedBufferedImage;

    private void clearCache() {
        this.cachedScale = 0.0;
        this.cachedBufferedImage = null;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicPrintPreviewPageUI();
    }

    public double getFixedWidth(JPrintPreviewPage jPrintPreviewPage) {
        Insets insets = jPrintPreviewPage.getInsets();
        return this.borderThickness + this.borderThickness + this.shadowThickness + insets.left + insets.right;
    }

    public double getFixedHeight(JPrintPreviewPage jPrintPreviewPage) {
        Insets insets = jPrintPreviewPage.getInsets();
        double d = 0.0;
        JPrintPreviewPane jPrintPreviewPane = jPrintPreviewPage.getJPrintPreviewPane();
        if (jPrintPreviewPane.getPageNumbersAreShown()) {
            int n = jPrintPreviewPage.getPageIndex();
            boolean bl = jPrintPreviewPane.isPageSelected(n);
            int n2 = n + 1;
            PageNumberRenderer pageNumberRenderer = jPrintPreviewPane.getPageNumberRenderer();
            Component component = pageNumberRenderer.getPageNumberRendererComponent(jPrintPreviewPane, n2, bl, jPrintPreviewPage.isFocusOwner());
            Dimension dimension = component.getPreferredSize();
            d = dimension.getHeight();
        }
        return (double)(this.borderThickness + this.borderThickness + this.shadowThickness) + d + (double)insets.top + (double)insets.bottom;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        JPrintPreviewPage jPrintPreviewPage = (JPrintPreviewPage)jComponent;
        PageFormat pageFormat = jPrintPreviewPage.getPageFormat();
        double d = pageFormat.getWidth();
        double d2 = pageFormat.getHeight();
        Insets insets = jPrintPreviewPage.getInsets();
        double d3 = d + (double)insets.left + (double)insets.right + (double)this.borderThickness + (double)this.borderThickness + (double)this.shadowThickness;
        double d4 = d2 + (double)insets.top + (double)insets.bottom + (double)this.borderThickness + (double)this.borderThickness + (double)this.shadowThickness;
        JPrintPreviewPane jPrintPreviewPane = jPrintPreviewPage.getJPrintPreviewPane();
        double d5 = d3;
        double d6 = d4;
        if (jPrintPreviewPane.getPageNumbersAreShown()) {
            int n = jPrintPreviewPage.getPageIndex();
            boolean bl = jPrintPreviewPane.isPageSelected(n);
            PageNumberRenderer pageNumberRenderer = jPrintPreviewPane.getPageNumberRenderer();
            int n2 = n + 1;
            Component component = pageNumberRenderer.getPageNumberRendererComponent(jPrintPreviewPane, n2, bl, jPrintPreviewPage.isFocusOwner());
            Dimension dimension = component.getPreferredSize();
            d5 = Math.max(d3, dimension.getWidth());
            d6 = d4 + dimension.getHeight();
        }
        return new Dimension((int)d5, (int)d6);
    }

    public Dimension getScaleablePreferredSize(JPrintPreviewPage jPrintPreviewPage) {
        PageFormat pageFormat = jPrintPreviewPage.getPageFormat();
        double d = pageFormat.getWidth();
        double d2 = pageFormat.getHeight();
        return new Dimension((int)d, (int)d2);
    }

    protected void installDefaults() {
        this.borderThickness = UIManager.getInt(BORDER_THICKNESS_KEY);
        this.borderThickness = Math.max(0, this.borderThickness);
        this.shadowThickness = UIManager.getInt(SHADOW_THICKNESS_KEY);
        this.shadowThickness = Math.max(0, this.shadowThickness);
        this.shadowColor = UIManager.getColor(SHADOW_COLOR_KEY);
        this.marginColor = UIManager.getColor(MARGIN_COLOR_KEY);
        this.marginStroke = (Stroke)UIManager.get(MARGIN_STROKE_KEY);
        this.cachingPolicy = UIManager.getString(CACHING_POLICY_KEY);
        Utility.installDefaultBackground(this.printPreviewPage, BACKGROUND_KEY);
        Utility.installDefaultForeground(this.printPreviewPage, FOREGROUND_KEY);
    }

    public void installUI(JComponent jComponent) {
        this.printPreviewPage = (JPrintPreviewPage)jComponent;
        this.clearCache();
        this.installDefaults();
        this.installChildren();
    }

    private void installChildren() {
        this.rendererPane = new CellRendererPane();
        this.printPreviewPage.add(this.rendererPane);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Printable printable;
        Graphics2D graphics2D;
        int n;
        int n2;
        int n3;
        JPrintPreviewPage jPrintPreviewPage = (JPrintPreviewPage)jComponent;
        Graphics2D graphics2D2 = (Graphics2D)graphics.create();
        PageFormat pageFormat = jPrintPreviewPage.getPageFormat();
        graphics2D2.addRenderingHints(hints);
        double d = pageFormat.getWidth();
        double d2 = pageFormat.getHeight();
        double d3 = jPrintPreviewPage.getWidth();
        double d4 = jPrintPreviewPage.getHeight();
        Insets insets = jPrintPreviewPage.getInsets();
        JPrintPreviewPane jPrintPreviewPane = jPrintPreviewPage.getJPrintPreviewPane();
        double d5 = 0.0;
        double d6 = d4;
        Component component = null;
        int n4 = jPrintPreviewPage.getPageIndex();
        boolean bl = jPrintPreviewPane.isPageSelected(n4);
        int n5 = n4 + 1;
        if (jPrintPreviewPane.getPageNumbersAreShown()) {
            PageNumberRenderer pageNumberRenderer = jPrintPreviewPane.getPageNumberRenderer();
            component = pageNumberRenderer.getPageNumberRendererComponent(jPrintPreviewPane, n5, bl, jPrintPreviewPage.isFocusOwner());
            Dimension dimension = component.getPreferredSize();
            d5 = dimension.getHeight();
            d6 = d4 - d5;
        }
        double d7 = d3 - (double)insets.left - (double)insets.right - (double)this.borderThickness - (double)this.borderThickness - (double)this.shadowThickness;
        double d8 = d6 - (double)insets.top - (double)insets.bottom - (double)this.borderThickness - (double)this.borderThickness - (double)this.shadowThickness;
        double d9 = d7 / d;
        double d10 = d8 / d2;
        double d11 = Math.min(d9, d10);
        double d12 = d * d11;
        double d13 = d2 * d11;
        double d14 = (d7 - d12) / 2.0;
        double d15 = (d8 - d13) / 2.0;
        int n6 = (int)((double)insets.left + d14);
        int n7 = (int)((double)insets.top + d15);
        int n8 = (int)(d12 + (double)this.borderThickness + (double)this.borderThickness + (double)this.shadowThickness);
        int n9 = (int)(d13 + (double)this.borderThickness + (double)this.borderThickness + (double)this.shadowThickness);
        Color color = jPrintPreviewPage.getForeground();
        Color color2 = jPrintPreviewPage.getBackground();
        Color color3 = graphics2D2.getColor();
        graphics2D2.setColor(this.shadowColor);
        graphics2D2.fillRect(n6 + this.shadowThickness, n7 + this.shadowThickness, n8 - this.shadowThickness, n9 - this.shadowThickness);
        if (bl) {
            graphics2D2.setColor(jPrintPreviewPane.getSelectionForeground());
        } else {
            graphics2D2.setColor(color);
        }
        graphics2D2.fillRect(n6, n7, n8 - this.shadowThickness, n9 - this.shadowThickness);
        graphics2D2.setColor(color2);
        graphics2D2.fillRect(n6 + this.borderThickness, n7 + this.borderThickness, n8 - this.borderThickness - this.borderThickness - this.shadowThickness, n9 - this.borderThickness - this.borderThickness - this.shadowThickness);
        graphics2D2.setColor(color3);
        if (jPrintPreviewPane.getPageNumbersAreShown()) {
            n3 = insets.left;
            n2 = insets.top + n9;
            n = (int)(d3 - (double)insets.left - (double)insets.right);
            this.rendererPane.paintComponent(graphics2D2, component, jPrintPreviewPage, n3, n2, n, (int)d5, true);
            this.rendererPane.removeAll();
        }
        n3 = (int)(pageFormat.getImageableX() * d11);
        n2 = (int)(pageFormat.getImageableY() * d11);
        n = (int)(pageFormat.getImageableWidth() * d11);
        int n10 = (int)(pageFormat.getImageableHeight() * d11);
        boolean bl2 = this.cachingPolicy.equals(NEVER_CACHE_VALUE);
        BufferedImage bufferedImage = null;
        if (this.cachedBufferedImage instanceof Reference) {
            bufferedImage = (BufferedImage)((Reference)this.cachedBufferedImage).get();
        } else if (this.cachedBufferedImage instanceof BufferedImage) {
            bufferedImage = (BufferedImage)this.cachedBufferedImage;
        }
        if (!(bl2 || this.cachedScale == d11 && bufferedImage != null)) {
            try {
                bufferedImage = new BufferedImage((int)d12, (int)d13, 2);
                graphics2D = bufferedImage.createGraphics();
                graphics2D.addRenderingHints(hints);
                graphics2D.setColor(color3);
                printable = jPrintPreviewPage.getPrintable();
                graphics2D.clipRect(n3, n2, n, n10);
                graphics2D.scale(d11, d11);
                BasicPrintPreviewPageUI.printPrintable(printable, graphics2D, pageFormat, n4);
                this.cachedBufferedImage = this.cachingPolicy.equals(MEMORY_SENSITIVE_CACHE_VALUE) ? new SoftReference<BufferedImage>(bufferedImage) : bufferedImage;
                this.cachedScale = d11;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                bl2 = true;
            }
        }
        graphics2D2.translate(n6 + this.borderThickness, n7 + this.borderThickness);
        if (bl2) {
            graphics2D = (Graphics2D)graphics2D2.create();
            graphics2D.clipRect(n3, n2, n, n10);
            graphics2D.scale(d11, d11);
            printable = jPrintPreviewPage.getPrintable();
            BasicPrintPreviewPageUI.printPrintable(printable, graphics2D, pageFormat, n4);
            graphics2D.dispose();
        } else {
            graphics2D2.drawImage(bufferedImage, null, 0, 0);
        }
        if (jPrintPreviewPane.getMarginsAreShown()) {
            this.paintMargins(graphics2D2, 0, 0, d11, pageFormat);
        }
        graphics2D2.dispose();
    }

    private void paintMargins(Graphics2D graphics2D, int n, int n2, double d, PageFormat pageFormat) {
        graphics2D.setColor(this.marginColor);
        double d2 = pageFormat.getImageableX();
        double d3 = pageFormat.getImageableY();
        double d4 = pageFormat.getImageableWidth();
        double d5 = pageFormat.getImageableHeight();
        int n3 = n + (int)(d2 * d);
        int n4 = n2 + (int)(d3 * d);
        int n5 = (int)(d4 * d);
        int n6 = (int)(d5 * d);
        graphics2D.setStroke(this.marginStroke);
        graphics2D.drawRect(n3, n4, n5, n6);
    }

    private static void printPrintable(Printable printable, Graphics graphics, PageFormat pageFormat, int n) {
        try {
            printable.print(graphics, pageFormat, n);
        }
        catch (PrinterException printerException) {
            printerException.printStackTrace();
        }
    }

    private void uninstallChildren() {
        this.printPreviewPage.remove(this.rendererPane);
        this.rendererPane = null;
    }

    protected void uninstallDefaults() {
        Utility.uninstallDefaultBackground(this.printPreviewPage);
        Utility.uninstallDefaultForeground(this.printPreviewPage);
    }

    public void uninstallUI(JComponent jComponent) {
        this.clearCache();
        this.uninstallChildren();
        this.uninstallDefaults();
        this.printPreviewPage = null;
    }

    static {
        hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        Utility.initDefault(BORDER_THICKNESS_KEY, new Integer(1));
        Utility.initDefault(SHADOW_THICKNESS_KEY, new Integer(3));
        Utility.initDefault(BACKGROUND_KEY, new ColorUIResource(Color.white));
        Utility.initDefault(FOREGROUND_KEY, new ColorUIResource(Color.black));
        Utility.initDefault(SHADOW_COLOR_KEY, new ColorUIResource(Color.black.brighter()));
        Utility.initDefault(MARGIN_COLOR_KEY, new ColorUIResource(Color.gray));
        Utility.initDefault(MARGIN_STROKE_KEY, new BasicStroke(1.0f, 0, 1, 0.0f, new float[]{5.0f}, 0.0f));
        Utility.initDefault(CACHING_POLICY_KEY, NEVER_CACHE_VALUE);
    }
}

